<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePersonaMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('persona_messages', function (Blueprint $table) {
            $table->increments('id');

            $table->text("message")->nullable();

            $table->integer('persona_id')->unsigned();
            $table->foreign('persona_id')->references('id')->on('personas')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('persona_cumpleanio_id')->unsigned();
            $table->foreign('persona_cumpleanio_id')->references('id')->on('personas')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('persona_messages');
    }
}
