<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePersonasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personas', function (Blueprint $table) {
            $table->increments('id');

            $table->string('slug')->nullable();
            $table->string('apellidos_nombres')->nullable();
            $table->string('dni',12)->nullable();
            $table->string('email', 90)->unique()->nullable();
            $table->string('telefono_personal',9)->nullable();
            $table->string('telefono_empresa',9)->nullable();
            $table->string('anexo')->nullable();
            $table->date('fecha_nacimiento')->nullable();
            $table->string('estado_civil',40)->nullable();
            $table->char('genero',1)->nullable();
            $table->string('foto')->nullable();

            $table->integer('cargo_id')->unsigned();
            $table->foreign('cargo_id')->references('id')->on('cargos')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('personas');
    }
}
