<?php
Route::group(['middleware' => 'web'], function () {
    Route::get('/', function () {
        return redirect()->route('admin.login');
    });

    Route::get('/login', [
        'as' => 'admin.login',
        'uses' => 'Auth\AdminController@getLogin'
    ]);

    Route::post('/login', [
        'as' => 'admin.login',
        'uses' => 'Auth\AdminController@postLogin'
    ]);

    Route::get('/logout', [
        'as' => 'admin.logout',
        'uses' => 'Auth\AdminController@logout'
    ]);

    Route::group(['middleware' => 'admin'], function () {
        Route::get('/', [
            'as' => 'admin.index',
            'uses' => 'Admin\AdminController@index'
        ]);

        Route::get('/cambiar-password', [
            'as' => 'admin.cambiarpassword',
            'uses' => 'Admin\AdminController@password'
        ]);

        Route::post('/cambiar-password', [
            'as' => 'admin.cambiarpassword',
            'uses' => 'Admin\AdminController@changePassword'
        ]);

        Route::get('/favorito/{idPersona}', [
            'as' => 'admin.favorito',
            'uses' => 'Admin\Favorito\FavoritoController@store'
        ]);

        Route::group(['prefix' => 'ajax'], function () {
            Route::get('/', [
                'as' => 'admin.ajax.index',
                'uses' => 'Admin\Ajax\AjaxController@index'
            ]);

            Route::get('/categoria-tickets/{sub_lista_id?}', [
                'as' => 'admin.ajax.categoriatickets',
                'uses' => 'Admin\Ajax\AjaxController@categoriaTickets'
            ]);

            Route::get('/buscar-ticket/{codigo?}', [
                'as' => 'admin.ajax.buscarticket',
                'uses' => 'Admin\Ajax\AjaxController@buscarTicket'
            ]);

            Route::get('/dircorp-noticias', [
                'as' => 'admin.ajax.dircorpnoticias',
                'uses' => 'Admin\Ajax\AjaxController@dircorpNoticias'
            ]);

            Route::get('/dircorp-noticias-detalle/{slug?}', [
                'as' => 'admin.ajax.dircorpnoticiasdetalle',
                'uses' => 'Admin\Ajax\AjaxController@dircorpNoticiasDetalle'
            ]);

        });

        Route::group(['prefix' => 'sede', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.sede.index',
                'uses' => 'Admin\Sede\SedeController@index'
            ]);

            Route::get('/{slug}', [
                'as' => 'admin.sede.detalle',
                'uses' => 'Admin\Sede\SedeController@show'
            ]);

            Route::get('/{slug}/area/{slugarea?}', [
                'as' => 'admin.sede.area',
                'uses' => 'Admin\Sede\SedeController@area'
            ]);

            Route::get('/{slug}/area/{slugarea}/persona/{slugpersona?}', [
                'as' => 'admin.sede.area.persona',
                'uses' => 'Admin\Sede\SedeController@persona'
            ]);

            Route::get('/{slug}/area/{slugarea}/persona/{slugpersona?}/companieros', [
                'as' => 'admin.sede.area.persona.companieros',
                'uses' => 'Admin\Sede\SedeController@personaCompanieros'
            ]);

        });

        Route::group(['prefix' => 'area', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.area.index',
                'uses' => 'Admin\Area\AreaController@index'
            ]);

            Route::get('/{slug}', [
                'as' => 'admin.area.detalle',
                'uses' => 'Admin\Area\AreaController@show'
            ]);

            Route::get('/{slug}/persona/{slugpersona?}', [
                'as' => 'admin.area.persona',
                'uses' => 'Admin\Area\AreaController@persona'
            ]);

            Route::get('/{slug}/persona/{slugpersona?}/companieros', [
                'as' => 'admin.area.persona.companieros',
                'uses' => 'Admin\Area\AreaController@personaCompanieros'
            ]);

        });

        Route::group(['prefix' => 'persona', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.persona.index',
                'uses' => 'Admin\Persona\PersonaController@index'
            ]);

            Route::get('/{slug}', [
                'as' => 'admin.persona.detalle',
                'uses' => 'Admin\Persona\PersonaController@show'
            ]);

            Route::get('/{slug}/companieros', [
                'as' => 'admin.persona.detalle.companieros',
                'uses' => 'Admin\Persona\PersonaController@companieros'
            ]);

            Route::post('/buscar/{name}', [
                'as' => 'admin.persona.buscar',
                'uses' => 'Admin\AdminController@buscarPersona'
            ]);
        });

        Route::group(['prefix' => 'cumpleanios', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.cumpleanios.index',
                'uses' => 'Admin\Persona\PersonaController@cumpleanios'
            ]);

            Route::post('/enviar-mensaje', [
                'as' => 'admin.cumpleanios.sendmessage',
                'uses' => 'Admin\Persona\PersonaController@cumpleaniosSendMessage'
            ]);
        });

        Route::group(['prefix' => 'perfil', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.perfil.index',
                'uses' => 'Admin\Persona\PersonaController@perfil'
            ]);

            Route::post('/cambiarfoto/{id}', [
                'as' => 'admin.perfil.foto',
                'uses' => 'Admin\Persona\PersonaController@foto'
            ]);

            Route::post('/editarbasic/{id}', [
                'as' => 'admin.perfil.update.basic',
                'uses' => 'Admin\Persona\PersonaController@updateBasic'
            ]);

            Route::post('/editarcontac/{id}', [
                'as' => 'admin.perfil.update.contact',
                'uses' => 'Admin\Persona\PersonaController@updateContact'
            ]);

            Route::get('/saludos', [
                'as' => 'admin.perfil.cumpleanio',
                'uses' => 'Admin\Persona\PersonaController@cumpleaniosMessage'
            ]);
        });

        Route::group(['prefix' => 'favoritos', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.favoritos.index',
                'uses' => 'Admin\Favorito\FavoritoController@index'
            ]);
        });

        Route::group(['prefix' => 'tickets', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.tickets.index',
                'uses' => 'Admin\Tickets\TicketsController@index'
            ]);

            Route::get('/crear', [
                'as' => 'admin.tickets.crear',
                'uses' => 'Admin\Tickets\TicketsController@create'
            ]);

            Route::post('/crear', [
                'as' => 'admin.tickets.crear',
                'uses' => 'Admin\Tickets\TicketsController@store'
            ]);
        });

        Route::group(['prefix' => 'noticias', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.noticias.index',
                'uses' => 'Admin\Noticias\NoticiasController@index'
            ]);

            Route::get('/{slug?}', [
                'as' => 'admin.noticias.detalle',
                'uses' => 'Admin\Noticias\NoticiasController@detalle'
            ]);
        });

        Route::group(['prefix' => 'recursos-humanos', 'middleware' => 'role:superadmin|admin|user'], function () {
            Route::get('/', [
                'as' => 'admin.recursoshumanos.index',
                'uses' => 'Admin\RecursosHumanos\RecursosHumanosController@index'
            ]);

//            Route::get('/{slug?}', [
//                'as' => 'admin.noticias.detalle',
//                'uses' => 'Admin\Noticias\NoticiasController@detalle'
//            ]);
        });

    });

    /** SuperAdmin */
    Route::group(['prefix' => 'superadmin'], function () {
        Route::get('/login', [
            'as' => 'superadmin.login',
            'uses' => 'Auth\SuperAdminController@getLogin'
        ]);

        Route::post('/login', [
            'as' => 'superadmin.login',
            'uses' => 'Auth\SuperAdminController@postLogin'
        ]);

        Route::get('/logout', [
            'as' => 'superadmin.logout',
            'uses' => 'Auth\SuperAdminController@logout'
        ]);
    });

    /** Soporte */
    Route::group(['prefix' => 'soporte'], function () {
        Route::get('/login', [
            'as' => 'soporte.login',
            'uses' => 'Auth\SoporteController@getLogin'
        ]);

        Route::post('/login', [
            'as' => 'soporte.login',
            'uses' => 'Auth\SoporteController@postLogin'
        ]);

        Route::get('/logout', [
            'as' => 'soporte.logout',
            'uses' => 'Auth\SoporteController@logout'
        ]);
    });
});
