<?php
if(version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'superadmin', 'middleware' => ['web', 'superadmin']], function () {
    Route::get('/', [
        'as' => 'superadmin.index',
        'uses' => 'Superadmin\SuperAdminController@index'
    ]);

    Route::get('/cambiar-contrasenia', [
        'as' => 'superadmin.password',
        'uses' => 'Superadmin\SuperAdminController@password'
    ]);

    Route::post('/cambiar-contrasenia', [
        'as' => 'superadmin.changepassword',
        'uses' => 'Superadmin\SuperAdminController@changePassword'
    ]);

    Route::group(['prefix' => 'ajax'], function () {

        Route::post('/area/{id}', [
            'as' => 'superadmin.ajax.area',
            'uses' => 'Superadmin\SuperAdminController@area'
        ]);

        Route::post('/cargo/{id}', [
            'as' => 'superadmin.ajax.cargo',
            'uses' => 'Superadmin\SuperAdminController@cargo'
        ]);

        Route::post('/persona/{id}', [
            'as' => 'superadmin.ajax.persona',
            'uses' => 'Superadmin\SuperAdminController@persona'
        ]);

    });

    Route::group(['prefix' => 'sedes'], function () {
        Route::get('/', [
            'as' => 'superadmin.sedes.index',
            'uses' => 'Superadmin\Sede\SedeController@index'
        ]);

        Route::get('/detalle/{slug}', [
            'as' => 'superadmin.sedes.show',
            'uses' => 'Superadmin\Sede\SedeController@show'
        ]);

        Route::get('/crear', [
            'as' => 'superadmin.sedes.create',
            'uses' => 'Superadmin\Sede\SedeController@create'
        ]);

        Route::post('/crear', [
            'as' => 'superadmin.sedes.create',
            'uses' => 'Superadmin\Sede\SedeController@store'
        ]);

        Route::get('/editar/{slug}', [
            'as' => 'superadmin.sedes.edit',
            'uses' => 'Superadmin\Sede\SedeController@edit'
        ]);

        Route::post('/editar/{id}', [
            'as' => 'superadmin.sedes.edit',
            'uses' => 'Superadmin\Sede\SedeController@update'
        ]);

        Route::delete('/eliminar/{id}', [
            'as' => 'superadmin.sedes.delete',
            'uses' => 'Superadmin\Sede\SedeController@destroy'
        ]);

    });

    Route::group(['prefix' => 'areas'], function () {
        Route::get('/', [
            'as' => 'superadmin.areas.index',
            'uses' => 'Superadmin\Area\AreaController@index'
        ]);

        Route::get('/detalle/{slug}/{idSede}', [
            'as' => 'superadmin.areas.show',
            'uses' => 'Superadmin\Area\AreaController@show'
        ]);

        Route::get('/crear', [
            'as' => 'superadmin.areas.create',
            'uses' => 'Superadmin\Area\AreaController@create'
        ]);

        Route::post('/crear', [
            'as' => 'superadmin.areas.create',
            'uses' => 'Superadmin\Area\AreaController@store'
        ]);

        Route::get('/editar/{slug}/{idSede}', [
            'as' => 'superadmin.areas.edit',
            'uses' => 'Superadmin\Area\AreaController@edit'
        ]);

        Route::post('/editar/{id}', [
            'as' => 'superadmin.areas.update',
            'uses' => 'Superadmin\Area\AreaController@update'
        ]);

        Route::delete('/eliminar/{id}', [
            'as' => 'superadmin.areas.delete',
            'uses' => 'Superadmin\Area\AreaController@destroy'
        ]);

    });

    Route::group(['prefix' => 'cargos'], function () {
        Route::get('/', [
            'as' => 'superadmin.cargos.index',
            'uses' => 'Superadmin\Cargo\CargoController@index'
        ]);

        Route::get('/detalle/{slug}/{idArea}', [
            'as' => 'superadmin.cargos.show',
            'uses' => 'Superadmin\Cargo\CargoController@show'
        ]);

        Route::get('/crear', [
            'as' => 'superadmin.cargos.create',
            'uses' => 'Superadmin\Cargo\CargoController@create'
        ]);

        Route::post('/crear', [
            'as' => 'superadmin.cargos.create',
            'uses' => 'Superadmin\Cargo\CargoController@store'
        ]);

        Route::get('/editar/{slug}/{idArea}', [
            'as' => 'superadmin.cargos.edit',
            'uses' => 'Superadmin\Cargo\CargoController@edit'
        ]);

        Route::post('/editar/{id}', [
            'as' => 'superadmin.cargos.update',
            'uses' => 'Superadmin\Cargo\CargoController@update'
        ]);

        Route::delete('/eliminar/{id}', [
            'as' => 'superadmin.cargos.delete',
            'uses' => 'Superadmin\Cargo\CargoController@destroy'
        ]);

    });

    Route::group(['prefix' => 'personas'], function () {
        Route::get('/', [
            'as' => 'superadmin.personas.index',
            'uses' => 'Superadmin\Persona\PersonaController@index'
        ]);

        Route::get('/detalle/{slug}', [
            'as' => 'superadmin.personas.show',
            'uses' => 'Superadmin\Persona\PersonaController@show'
        ]);

        Route::get('/crear', [
            'as' => 'superadmin.personas.create',
            'uses' => 'Superadmin\Persona\PersonaController@create'
        ]);

        Route::post('/crear', [
            'as' => 'superadmin.personas.create',
            'uses' => 'Superadmin\Persona\PersonaController@store'
        ]);

        Route::get('/editar/{slug}', [
            'as' => 'superadmin.personas.edit',
            'uses' => 'Superadmin\Persona\PersonaController@edit'
        ]);

        Route::post('/editar/{id}', [
            'as' => 'superadmin.personas.edit',
            'uses' => 'Superadmin\Persona\PersonaController@update'
        ]);

        Route::delete('/eliminar/{id}', [
            'as' => 'superadmin.personas.delete',
            'uses' => 'Superadmin\Persona\PersonaController@destroy'
        ]);

        Route::post('/saludo-bienvenido/{id}', [
            'as' => 'superadmin.personas.welcome',
            'uses' => 'Superadmin\Persona\PersonaController@welcome'
        ]);

        Route::get('/firma-correo/{id}', [
            'as' => 'superadmin.personas.firmacorreo',
            'uses' => 'Superadmin\Persona\PersonaController@firmaCorreo'
        ]);
    });

    Route::group(['prefix' => 'cumpleanios'], function () {
        Route::get('/', [
            'as' => 'superadmin.cumpleanios.index',
            'uses' => 'Superadmin\Persona\PersonaController@cumpleanios'
        ]);
        Route::get('/personal/{slug}', [
            'as' => 'superadmin.cumpleanios.personal.show',
            'uses' => 'Superadmin\Persona\PersonaController@cumpleaniosPersonal'
        ]);
        Route::post('/cumpleanio/{id}', [
            'as' => 'superadmin.cumpleanios.cumpleanioenvio',
            'uses' => 'Superadmin\Persona\PersonaController@cumpleanioEnvio'
        ]);
        Route::get('/tarjeta-permiso', function () {
            return redirect()->route('superadmin.cumpleanios.index');
        });
        Route::get('/tarjeta-permiso/{slug}', [
            'as' => 'superadmin.cumpleanios.personal.tarjetapermiso',
            'uses' => 'Superadmin\Persona\PersonaController@tarjetapermiso'
        ]);
    });

    Route::group(['prefix' => 'usuarios'], function () {
        Route::get('/', [
            'as' => 'superadmin.usuarios.index',
            'uses' => 'Superadmin\User\UserController@index'
        ]);

        Route::get('/detalle/{id}', [
            'as' => 'superadmin.usuarios.show',
            'uses' => 'Superadmin\User\UserController@show'
        ]);

        Route::get('/crear', [
            'as' => 'superadmin.usuarios.create',
            'uses' => 'Superadmin\User\UserController@create'
        ]);

        Route::post('/crear', [
            'as' => 'superadmin.usuarios.create',
            'uses' => 'Superadmin\User\UserController@store'
        ]);

        Route::get('/editar/{id}', [
            'as' => 'superadmin.usuarios.edit',
            'uses' => 'Superadmin\User\UserController@edit'
        ]);

        Route::post('/editar/{id}', [
            'as' => 'superadmin.usuarios.edit',
            'uses' => 'Superadmin\User\UserController@update'
        ]);

        Route::delete('/eliminar/{id}', [
            'as' => 'superadmin.usuarios.delete',
            'uses' => 'Superadmin\User\UserController@destroy'
        ]);

        Route::post('/restore/{id}', [
            'as' => 'superadmin.usuarios.restore',
            'uses' => 'Superadmin\User\UserController@restore'
        ]);

        Route::get('/password/{id}', [
            'as' => 'superadmin.usuarios.password',
            'uses' => 'Superadmin\User\UserController@password'
        ]);

        Route::post('/password/{id}', [
            'as' => 'superadmin.usuarios.password',
            'uses' => 'Superadmin\User\UserController@changePassword'
        ]);
    });

    Route::group(['prefix' => 'recursos-humanos'], function () {
        Route::get('/', [
            'as' => 'superadmin.recursoshumanos.index',
            'uses' => 'Superadmin\RecursosHumanos\RecursosHumanosController@index'
        ]);

        Route::get('/subir-archivos', [
            'as' => 'superadmin.recursoshumanos.subirarchivos',
            'uses' => 'Superadmin\RecursosHumanos\RecursosHumanosController@subirArchivos'
        ]);

        Route::post('/crear-archivos', [
            'as' => 'superadmin.recursoshumanos.creararchivos',
            'uses' => 'Superadmin\RecursosHumanos\RecursosHumanosController@storeArchivos'
        ]);

        Route::delete('/eliminar-archivos/{id?}', [
            'as' => 'superadmin.recursoshumanos.eliminararchivos',
            'uses' => 'Superadmin\RecursosHumanos\RecursosHumanosController@eliminarArchivos'
        ]);
    });


    Route::group(['prefix' => 'herramientas'], function () {
        Route::get('/', [
            'as' => 'superadmin.herramientas.index',
            'uses' => 'Superadmin\Herramientas\HerramientasController@index'
        ]);

        Route::group(['prefix' => 'listas'], function () {
            Route::get('/', [
                'as' => 'superadmin.herramientas.listas.index',
                'uses' => 'Superadmin\Herramientas\Listas\ListasController@index'
            ]);

            Route::get('/crear', [
                'as' => 'superadmin.herramientas.listas.crear',
                'uses' => 'Superadmin\Herramientas\Listas\ListasController@create'
            ]);

            Route::post('/crear', [
                'as' => 'superadmin.herramientas.listas.crear',
                'uses' => 'Superadmin\Herramientas\Listas\ListasController@store'
            ]);

            Route::get('/{slug}', function () {
                return redirect()->route('superadmin.herramientas.listas.index');
            });

            Route::get('/{slug}/detalle', [
                'as' => 'superadmin.herramientas.listas.detalle',
                'uses' => 'Superadmin\Herramientas\Listas\ListasController@show'
            ]);

            Route::get('/{slug}/editar', [
                'as' => 'superadmin.herramientas.listas.editar',
                'uses' => 'Superadmin\Herramientas\Listas\ListasController@edit'
            ]);

            Route::post('/{id}/editar', [
                'as' => 'superadmin.herramientas.listas.editar',
                'uses' => 'Superadmin\Herramientas\Listas\ListasController@update'
            ]);

            Route::get('/{slug}/sublista', [
                'as' => 'superadmin.herramientas.listas.sublista.index',
                'uses' => 'Superadmin\Herramientas\Listas\ListasSubController@index'
            ]);

            Route::get('/{slug}/sublista/crear', [
                'as' => 'superadmin.herramientas.listas.sublista.crear',
                'uses' => 'Superadmin\Herramientas\Listas\ListasSubController@create'
            ]);

            Route::post('/{slug}/sublista/crear', [
                'as' => 'superadmin.herramientas.listas.sublista.crear',
                'uses' => 'Superadmin\Herramientas\Listas\ListasSubController@store'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}', function ($slug) {
                return redirect()->route('superadmin.herramientas.listas.sublista.index', $slug);
            });

            Route::get('/{slug}/sublista/{slugSubLista}/detalle', [
                'as' => 'superadmin.herramientas.listas.sublista.detalle',
                'uses' => 'Superadmin\Herramientas\Listas\ListasSubController@show'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/editar', [
                'as' => 'superadmin.herramientas.listas.sublista.editar',
                'uses' => 'Superadmin\Herramientas\Listas\ListasSubController@edit'
            ]);

            Route::post('/{slug}/sublista/{id}/editar', [
                'as' => 'superadmin.herramientas.listas.sublista.editar',
                'uses' => 'Superadmin\Herramientas\Listas\ListasSubController@update'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub', [
                'as' => 'superadmin.herramientas.listas.sublista.sub.index',
                'uses' => 'Superadmin\Herramientas\Listas\SubListasSubController@index'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub/crear', [
                'as' => 'superadmin.herramientas.listas.sublista.sub.crear',
                'uses' => 'Superadmin\Herramientas\Listas\SubListasSubController@create'
            ]);

            Route::post('/{slug}/sublista/{slugSubLista}/sub/crear', [
                'as' => 'superadmin.herramientas.listas.sublista.sub.crear',
                'uses' => 'Superadmin\Herramientas\Listas\SubListasSubController@store'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub/{slugSub}/detalle', [
                'as' => 'superadmin.herramientas.listas.sublista.sub.detalle',
                'uses' => 'Superadmin\Herramientas\Listas\SubListasSubController@show'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub/{slugSub}/editar', [
                'as' => 'superadmin.herramientas.listas.sublista.sub.editar',
                'uses' => 'Superadmin\Herramientas\Listas\SubListasSubController@edit'
            ]);

            Route::post('/{slug}/sublista/{slugSubLista}/sub/{id}/editar', [
                'as' => 'superadmin.herramientas.listas.sublista.sub.editar',
                'uses' => 'Superadmin\Herramientas\Listas\SubListasSubController@update'
            ]);
        });

        Route::group(['prefix' => 'reportes'], function () {
            Route::get('/', [
                'as' => 'superadmin.herramientas.reportes.index',
                'uses' => 'Superadmin\Herramientas\Reportes\ReportesController@index'
            ]);
            Route::group(['prefix' => 'cumpleanios'], function () {
                Route::get('/', [
                    'as' => 'superadmin.herramientas.reportes.cumpleanios.index',
                    'uses' => 'Superadmin\Herramientas\Reportes\Cumpleanios\CumpleaniosController@index'
                ]);

                Route::get('/filtromes/{mes?}', [
                    'as' => 'superadmin.herramientas.reportes.cumpleanios.filtromes',
                    'uses' => 'Superadmin\Herramientas\Reportes\Cumpleanios\CumpleaniosController@loadFilterCumpleanioMes'
                ]);

            });
        });

//        Route::get('testSaludo', 'Superadmin\Herramienta\HerramientaController@testSaludo');
//        Route::get('importsede', 'Superadmin\Herramienta\HerramientaController@importSede');
//        Route::get('importarea', 'Superadmin\Herramientas\HerramientasController@importArea');
//        Route::get('importcargo', 'Superadmin\Herramientas\HerramientasController@importCargo');
//        Route::get('importpersonal', 'Superadmin\Herramientas\HerramientasController@importPersonal');
    });

//    Route::group(['prefix' => 'tickets', 'middleware' => 'rolSoporte'], function () {
//        Route::get('/', [
//            'as' => 'superadmin.tickets.index',
//            'uses' => 'Superadmin\Tickets\TicketsController@index'
//        ]);
//
//        Route::group(['prefix' => 'pendientes'], function () {
//            Route::get('/', [
//                'as' => 'superadmin.tickets.pendientes.index',
//                'uses' => 'Superadmin\Tickets\Pendientes\PendientesController@index'
//            ]);
//            Route::get('/{codigo}/detalle', [
//                'as' => 'superadmin.tickets.pendientes.detalle',
//                'uses' => 'Superadmin\Tickets\Pendientes\PendientesController@show'
//            ]);
//            Route::post('/{id}/editar', [
//                'as' => 'superadmin.tickets.pendientes.editar',
//                'uses' => 'Superadmin\Tickets\Pendientes\PendientesController@update'
//            ]);
//        });
//
//        Route::group(['prefix' => 'asignados'], function () {
//            Route::get('/', [
//                'as' => 'superadmin.tickets.asignados.index',
//                'uses' => 'Superadmin\Tickets\Asignados\AsignadosController@index'
//            ]);
//            Route::get('/{codigo}/detalle', [
//                'as' => 'superadmin.tickets.asignados.detalle',
//                'uses' => 'Superadmin\Tickets\Asignados\AsignadosController@show'
//            ]);
//            Route::post('/{id}/editar', [
//                'as' => 'superadmin.tickets.asignados.editar',
//                'uses' => 'Superadmin\Tickets\Asignados\AsignadosController@update'
//            ]);
//
//        });
//
//        Route::group(['prefix' => 'con-incidencias'], function () {
//            Route::get('/', [
//                'as' => 'superadmin.tickets.conincidencias.index',
//                'uses' => 'Superadmin\Tickets\ConIncidencias\ConIncidenciasController@index'
//            ]);
//            Route::get('/{codigo}/detalle', [
//                'as' => 'superadmin.tickets.conincidencias.detalle',
//                'uses' => 'Superadmin\Tickets\ConIncidencias\ConIncidenciasController@show'
//            ]);
//            Route::post('/{id}/editar', [
//                'as' => 'superadmin.tickets.conincidencias.editar',
//                'uses' => 'Superadmin\Tickets\ConIncidencias\ConIncidenciasController@update'
//            ]);
//        });
//
//        Route::group(['prefix' => 'atendidos'], function () {
//            Route::get('/', [
//                'as' => 'superadmin.tickets.atendidos.index',
//                'uses' => 'Superadmin\Tickets\Atendidos\AtendidosController@index'
//            ]);
//            Route::get('/{codigo}/detalle', [
//                'as' => 'superadmin.tickets.atendidos.detalle',
//                'uses' => 'Superadmin\Tickets\Atendidos\AtendidosController@show'
//            ]);
//            Route::post('/{id}/editar', [
//                'as' => 'superadmin.tickets.atendidos.editar',
//                'uses' => 'Superadmin\Tickets\Atendidos\AtendidosController@update'
//            ]);
//        });
//    });
});
