<?php
if(version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'soporte', 'middleware' => ['web', 'soporte']], function () {
    Route::get('/', [
        'as' => 'soporte.index',
        'uses' => 'Soporte\SoporteController@index'
    ]);

    Route::post('/ajax/filtro/tickets', [
        'as' => 'soporte.ajax.filtro.tickets',
        'uses' => 'Soporte\SoporteController@filtroTickets'
    ]);


    Route::group(['prefix' => 'tickets'], function () {
//        Route::get('/', [
//            'as' => 'soporte.tickets.index',
//            'uses' => 'Soporte\Tickets\TicketsController@index'
//        ]);
        Route::get('/', function () {
            return redirect()->route('soporte.index');
        });

        Route::get('/{ticket_id}', function () {
            return redirect()->route('soporte.index');
        });

        Route::post('/{codigo}/estado/{estado}', [
            'as' => 'soporte.tickets.estado',
            'uses' => 'Soporte\Tickets\TicketsController@ticketEstado'
        ]);

        Route::get('/{ticket_id}/detalle', [
            'as' => 'soporte.tickets.detalle',
            'uses' => 'Soporte\Tickets\TicketsController@show'
        ]);

        Route::delete('/eliminar/{ticketId}', [
            'as' => 'soporte.tickets.delete',
            'uses' => 'Soporte\Tickets\TicketsController@destroy'
        ]);
    });

    Route::group(['prefix' => 'herramientas'], function () {
        Route::get('/', [
            'as' => 'soporte.herramientas.index',
            'uses' => 'Soporte\Herramientas\HerramientasController@index'
        ]);

        Route::group(['prefix' => 'listas'], function () {
            Route::get('/', [
                'as' => 'soporte.herramientas.listas.index',
                'uses' => 'Soporte\Herramientas\Listas\ListasController@index'
            ]);

            Route::get('/crear', [
                'as' => 'soporte.herramientas.listas.crear',
                'uses' => 'Soporte\Herramientas\Listas\ListasController@create'
            ]);

            Route::post('/crear', [
                'as' => 'soporte.herramientas.listas.crear',
                'uses' => 'Soporte\Herramientas\Listas\ListasController@store'
            ]);

            Route::get('/{slug}', function () {
                return redirect()->route('soporte.herramientas.listas.index');
            });

            Route::get('/{slug}/detalle', [
                'as' => 'soporte.herramientas.listas.detalle',
                'uses' => 'Soporte\Herramientas\Listas\ListasController@show'
            ]);

            Route::get('/{slug}/editar', [
                'as' => 'soporte.herramientas.listas.editar',
                'uses' => 'Soporte\Herramientas\Listas\ListasController@edit'
            ]);

            Route::post('/{id}/editar', [
                'as' => 'soporte.herramientas.listas.editar',
                'uses' => 'Soporte\Herramientas\Listas\ListasController@update'
            ]);

            Route::get('/{slug}/sublista', [
                'as' => 'soporte.herramientas.listas.sublista.index',
                'uses' => 'Soporte\Herramientas\Listas\ListasSubController@index'
            ]);

            Route::get('/{slug}/sublista/crear', [
                'as' => 'soporte.herramientas.listas.sublista.crear',
                'uses' => 'Soporte\Herramientas\Listas\ListasSubController@create'
            ]);

            Route::post('/{slug}/sublista/crear', [
                'as' => 'soporte.herramientas.listas.sublista.crear',
                'uses' => 'Soporte\Herramientas\Listas\ListasSubController@store'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}', function ($slug) {
                return redirect()->route('soporte.herramientas.listas.sublista.index', $slug);
            });

            Route::get('/{slug}/sublista/{slugSubLista}/detalle', [
                'as' => 'soporte.herramientas.listas.sublista.detalle',
                'uses' => 'Soporte\Herramientas\Listas\ListasSubController@show'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/editar', [
                'as' => 'soporte.herramientas.listas.sublista.editar',
                'uses' => 'Soporte\Herramientas\Listas\ListasSubController@edit'
            ]);

            Route::post('/{slug}/sublista/{id}/editar', [
                'as' => 'soporte.herramientas.listas.sublista.editar',
                'uses' => 'Soporte\Herramientas\Listas\ListasSubController@update'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub', [
                'as' => 'soporte.herramientas.listas.sublista.sub.index',
                'uses' => 'Soporte\Herramientas\Listas\SubListasSubController@index'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub/crear', [
                'as' => 'soporte.herramientas.listas.sublista.sub.crear',
                'uses' => 'Soporte\Herramientas\Listas\SubListasSubController@create'
            ]);

            Route::post('/{slug}/sublista/{slugSubLista}/sub/crear', [
                'as' => 'soporte.herramientas.listas.sublista.sub.crear',
                'uses' => 'Soporte\Herramientas\Listas\SubListasSubController@store'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub/{slugSub}/detalle', [
                'as' => 'soporte.herramientas.listas.sublista.sub.detalle',
                'uses' => 'Soporte\Herramientas\Listas\SubListasSubController@show'
            ]);

            Route::get('/{slug}/sublista/{slugSubLista}/sub/{slugSub}/editar', [
                'as' => 'soporte.herramientas.listas.sublista.sub.editar',
                'uses' => 'Soporte\Herramientas\Listas\SubListasSubController@edit'
            ]);

            Route::post('/{slug}/sublista/{slugSubLista}/sub/{id}/editar', [
                'as' => 'soporte.herramientas.listas.sublista.sub.editar',
                'uses' => 'Soporte\Herramientas\Listas\SubListasSubController@update'
            ]);
        });
    });
});