<?php
if (version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'api', 'middleware' => ['cors']], function () {
    Route::group(['prefix' => 'v1'], function () {
        Route::group(['prefix' => 'trabajador'], function () {
            Route::get('/', 'Api\V1\Mobile\MobileController@index')->name('api.v1.trabajador.index');
            Route::get('/dni/{dni?}', 'Api\V1\Mobile\MobileController@persona')->name('api.v1.trabajador.persona');
        });

        Route::group(['prefix' => 'herramientas'], function () {
            Route::get('/', [
                'as' => 'api.v1.herramientas.index',
                'uses' => 'Api\V1\Herramientas\HerramientasController@index'
            ]);

            Route::post('clonartabla', [
                'as' => 'api.v1.herramientas.clonartabla',
                'uses' => 'Api\V1\Herramientas\HerramientasController@clonarTabla'
            ]);
        });
    });
});