<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class UserRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = (isset($this->id)) ? "," . $this->id : "";

        return [
            'username' => 'required|min:6|unique:users,username' . $id,
            'last_first_name' => 'required',
            'email' => 'email|unique:users,email' . $id,
            'role_id' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'username.required' => 'Requerido',
            'username.min' => 'Minimo 6 caracteres',
            'username.unique' => 'Ya está en uso',
            'last_first_name.required' => 'Requerido',
            'email.email' => 'E-mail incorrecto',
            'email.unique' => 'Ya está en uso',
            'role_id.required' => 'Requerido',
        ];
    }
}
