<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class TicketRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'tipo_ticket_id' => 'required',
            'categoria_ticket_id' => 'required',
            'asunto' => 'required',
            'descripcion' => 'required',
        ];
    }

    /**
     * @return array
     */
    public function messages()
    {
        return [
            'tipo_ticket_id.required' => 'Requerido',
            'categoria_ticket_id.required' => 'Requerido',
            'asunto.required' => 'Requerido',
            'descripcion.required' => 'Requerido',
        ];
    }
}
