<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class PersonaRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = (isset($this->id)) ? "," . $this->id : "";

        return [
            'apellidos_nombres' => 'required|min:6',
            'dni' => 'required|min:8|max:12|unique:personas,dni' . $id,
            'email' => 'unique:personas,email' . $id,
            'sede_id' => 'required',
            'area_id' => 'required',
            'cargo_id' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'apellidos_nombres.required' => 'Requerido',
            'apellidos_nombres.min' => 'Ingrese nombres correctos',
            'dni.required' => 'Requerido',
            'dni.min' => 'Ingrese D.N.I correcto',
            'dni.unique' => 'Ya está en uso',
            'email.unique' => 'Ya está en uso',
            'sede_id.required' => 'Seleccione',
            'area_id.required' => 'Seleccione',
            'cargo_id.required' => 'Seleccione',
        ];
    }
}
