<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class PersonaContactRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = (isset($this->id)) ? "," . $this->id : "";
        return [
            'email' => 'email|unique:personas,email' . $id,
        ];
    }

    public function messages()
    {
        return [
            'email.email' => 'E-mail incorrecto',
            'email.unique' => 'Ya está en uso',
        ];
    }
}
