<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class CargoRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'sede_id' => 'required',
            'area_id' => 'required',
            'nombre' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'sede_id.required' => 'Seleccione sede',
            'area_id.required' => 'Seleccione area',
            'nombre.required' => 'Requerido',
        ];
    }
}
