<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SuperAdminAuthenticated
{
    /**
     * @param $request
     * @param Closure $next
     * @param string $guard
     * @return \Illuminate\Http\RedirectResponse|mixed
     */
    public function handle($request, Closure $next, $guard = 'superadmin')
    {
        if (!Auth::guard($guard)->check()) {
            return redirect()->route('superadmin.login');
        }

        if (!Session::has('guard')) {
            Session::flush();
            Auth::guard($guard)->logout();
            return redirect()->route('superadmin.login');
        }

        return $next($request);
    }
}
