<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class Role
{
    /**
     * @param $request
     * @param Closure $next
     * @param null $role
     * @return \Illuminate\Http\RedirectResponse|mixed
     */
    public function handle($request, Closure $next, $role = null)
    {
        $user = Auth::guard('admin')->user();

        $roles = explode('|', $role);

        if (!in_array($user->role->name, $roles)) {
            return redirect()->route('admin.index');
//            abort(404);
        }
        return $next($request);
    }
}
