<?php

namespace App\Http\Controllers\Superadmin\User;

use App\Entities\Persona;
use App\Entities\UserPersona;
use App\Http\Requests\UserRequest;
use Illuminate\Http\Request;
use App\Entities\Role;
use App\Entities\User;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class UserController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/select2/select2.min',
            'assets/js/select2/select2es',
            'assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min'];

        $users = User::withTrashed()->with('role')->where('role_id', '!=', 1)->orderBy('created_at', 'DESC')->get();

        return view('superadmin.users.index', compact('styles', 'scripts', 'users'));
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $id)
    {
        if ($request->ajax()) {
            $roles = Role::where('id', '!=', 1)->pluck('description', 'id')->all();
            $userpersona = UserPersona::with('user', 'persona')->where('user_id', $id)->first();
            $persona = $userpersona->persona;
            $persona->sedeAreaCargo = Persona::sedeAreaCargo($persona->cargo_id);

            return view('superadmin.users.show', compact('roles', 'userpersona'));
        }
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create()
    {
        $roles = Role::where('id', '!=', 1)->pluck('description', 'id')->all();

        return view('superadmin.users.create', compact('roles'));
    }

    /**
     * @param UserRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(UserRequest $request)
    {
        if ($request->ajax()) {
            $user = new User($request->all());
            $user->last_first_name = mb_strtoupper($request->last_first_name);
            $user->remember_token = str_random(10);
            $user->save();

            $userPersona = new UserPersona();
            $userPersona->user_id = $user->id;
            $userPersona->persona_id = $request->persona_id;
            $userPersona->save();

            $message = 'Se creo el usuario correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.usuarios.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request, $id)
    {
        if ($request->ajax()) {
            $roles = Role::where('id', '!=', 1)->pluck('description', 'id')->all();
            $userpersona = UserPersona::with('user', 'persona')->where('user_id', $id)->first();
            $persona = $userpersona->persona;
            $persona->sedeAreaCargo = Persona::sedeAreaCargo($persona->cargo_id);

            return view('superadmin.users.edit', compact('roles', 'userpersona'));
        }
    }

    /**
     * @param UserRequest $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(UserRequest $request, $id)
    {
        if ($request->ajax()) {
            $data = $request->all();
            $data['last_first_name'] = mb_strtoupper($request->last_first_name);
            $user = User::find($id);
            $user->admin = 0;
            $user->slug = null;
            $user->update($data);

            $message = 'Se actualizo el usuario correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.usuarios.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $user = User::find($id);
            $user->delete();
            
            $userPersona = UserPersona::where('user_id', $user->id)->first();
            $persona = Persona::find($userPersona->persona_id);
            $persona->delete();

            $name = $user->full_name;
            $response = [
                'message' => "Se elimino correctamente a " . $name,
                'route' => route('superadmin.usuarios.index')
            ];

            return response()->json(['data' => $response]);
        }
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function password($id)
    {
        $user = User::withTrashed()->find($id);

        return view('superadmin.users.password', compact('user'));
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function changePassword(Request $request, $id)
    {
        if ($request->password != "") {
            $user = User::withTrashed()->find($id);
            $user->password = $request->password;
            $user->save();

            messageFlash('La contraseña se MODIFICO correctamente', 'success');
        } else messageFlash('La contraseña NO PUDO MODIFICARSE', 'danger');
        return redirect()->route('superadmin.usuarios.index');
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function restore(Request $request, $id)
    {
        if ($request->ajax()) {
            $user = User::withTrashed()->find($id);
            $user->restore();

            $userPersona = UserPersona::where('user_id', $user->id)->first();
            $persona = Persona::withTrashed()->find($userPersona->persona_id);
            $persona->restore();

            $name = $user->full_name;
            $response = [
                'message' => "Se restauro correctamente a " . $name,
                'route' => route('superadmin.usuarios.index')
            ];

            return response()->json(['data' => $response]);
        }
    }

}
