<?php

namespace App\Http\Controllers\Superadmin\Tickets;

use App\Entities\Persona;
use App\Entities\Ticket;
use App\Entities\TicketEstado;
use App\Entities\UserPersona;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class TicketsController extends Controller
{
    protected $userId;
    protected $viewController = "superadmin.tickets";
    protected $routeController = "superadmin.tickets.index";

    /**
     * TicketsController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $scripts = [
            'assets/js/charts/easypiechart/jquery.easypiechart',
            'assets/js/charts/easypiechart/easypiechart-init'
        ];

        $tickets = Ticket::get();
        $ticketsCount = Ticket::count();
        $reportEasyTickets = [];
        $pendiente = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.PENDIENTE');//PENDIENTE
        $asignados = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ASIGNADO');//ASIGNADO
        $conIncidencias = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.CONINCIDENCIA');//CONINCIDENCIA
        $atendidos = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ATENDIDO');//ATENDIDO
        if (count($tickets)) {
            foreach ($tickets as $key => $ticket) {
                $countPendientes = TicketEstado::where('pendiente_ticket_id', $pendiente)->whereNull('fecha_fin_pendiente')->orderBy('id', 'DESC')->count();
                $countAsignados = TicketEstado::where('asignado_ticket_id', $asignados)->whereNull('fecha_fin_asignado')->orderBy('id', 'DESC')->count();
                $countConIncidencias = TicketEstado::where('conincidencia_ticket_id', $conIncidencias)->whereNull('fecha_fin_conincidencia')->orderBy('id', 'DESC')->count();
                $countAtendidos = TicketEstado::where('atendido_ticket_id', $atendidos)->orderBy('id', 'DESC')->count();

                $reportEasyTickets['pendientes']['cantidad'] = $countPendientes;
                $reportEasyTickets['pendientes']['porcentaje'] = formatPrice((100 * $countPendientes) / $ticketsCount);
                $reportEasyTickets['asignados']['cantidad'] = $countAsignados;
                $reportEasyTickets['asignados']['porcentaje'] = formatPrice((100 * $countAsignados) / $ticketsCount);
                $reportEasyTickets['conIncidencias']['cantidad'] = $countConIncidencias;
                $reportEasyTickets['conIncidencias']['porcentaje'] = formatPrice((100 * $countConIncidencias) / $ticketsCount);
                $reportEasyTickets['atendidos']['cantidad'] = $countAtendidos;
                $reportEasyTickets['atendidos']['porcentaje'] = formatPrice((100 * $countAtendidos) / $ticketsCount);
            }
        }

        return view($this->viewController . '.index', compact('scripts', 'ticketsCount', 'reportEasyTickets'));
    }

    public function create()
    {

    }

    public function store()
    {

    }

    public function edit()
    {

    }

    public function update()
    {

    }

    public function destroy()
    {

    }
}
