<?php

namespace App\Http\Controllers\Superadmin;

use App\Entities\Area;
use App\Entities\Cargo;
use App\Entities\Persona;
use App\Entities\Sede;
use App\Entities\User;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class SuperAdminController extends Controller
{
    protected $userId;

    /**
     * AdminController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        return view('superadmin.index');
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function password(Request $request)
    {
        if ($request->ajax()) {
            $user = User::find($this->userId);
            return view('superadmin.herramientas.cambiarpassword.password', compact('user'));
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function changePassword(Request $request)
    {
        if ($request->ajax()) {
            if ($request->password != "") {
                $user = User::find($this->userId);
                $user->password = $request->password;
                $user->save();
                notifyFlash('La contraseña se MODIFICO correctamente', 'success');
            } else notifyFlash('La contraseña NO PUDO MODIFICARSE', 'danger', 'fa-times');
            return response()->json(['data' => 'result']);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function area(Request $request, $id)
    {
        if ($request->ajax()) {
            $areas = Area::where('sede_id', $id)->orderBy('nombre', 'asc')->pluck('id', 'nombre')->all();
            return response()->json(['data' => $areas]);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function cargo(Request $request, $id)
    {
        if ($request->ajax()) {
            $cargos = Cargo::where('area_id', $id)->orderBy('nombre', 'asc')->pluck('id', 'nombre')->all();
            return response()->json(['data' => $cargos]);
        }
    }

    /**
     * @param Request $request
     * @param $data
     * @return \Illuminate\Http\JsonResponse
     */
    public function persona(Request $request, $data)
    {
        if ($request->ajax()) {
            if (isset($data)) {
                $personas = Persona::with('cargo')
                    ->where('apellidos_nombres', 'like', '%' . $data . '%')
                    ->get();

                foreach ($personas as $key => $persona) {
                    $area = Area::find($persona->cargo->area_id);
                    $personas[$key]['area'] = $area;
                    $personas[$key]['sede'] = Sede::find($area->sede_id);
                }
                return response()->json($personas);
            }
            return response()->json(null);
        }
    }

}
