<?php

namespace App\Http\Controllers\Superadmin\Sede;

use App\Entities\Sede;
use App\Http\Requests\SedeRequest;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class SedeController extends Controller
{
    protected $userId;

    /**
     * AdminController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
            'assets/js/inputmask/jasny-bootstrap.min'];

        $sedes = Sede::withCount('areas')->orderBy('created_at', 'DESC')->get();

        return view('superadmin.sedes.index', compact('styles', 'scripts', 'sedes'));
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show($slug)
    {
        $sede = Sede::where('slug', $slug)->first();

        return view('superadmin.sedes.show', compact('sede'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create()
    {
        return view('superadmin.sedes.create');
    }

    /**
     * @param SedeRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(SedeRequest $request)
    {
        if ($request->ajax()) {
            $sede = new Sede($request->all());
            $sede->save();

            $message = 'Se creo la sede correctamente';
            messageFlash($message, 'success');

            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.sedes.index')
                ], 200);
        }
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($slug)
    {
        $sede = Sede::where('slug', $slug)->first();

        return view('superadmin.sedes.edit', compact('sede'));
    }

    /**
     * @param SedeRequest $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(SedeRequest $request, $id)
    {
        if ($request->ajax()) {
            $sede = Sede::find($id);
            $sede->slug = null;
            $sede->update($request->all());

            $message = 'Se actualizo la sede correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.sedes.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $sede = Sede::find($id);
            $sede->delete();
            $response = [
                'message' => "Se elimino correctamente"
            ];
            return response()->json(['data' => $response]);
        }
    }

}
