<?php

namespace App\Http\Controllers\Superadmin\RecursosHumanos;

use App\Entities\RrhhFiles;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Intervention\Image\Facades\Image;

ini_set('memory_limit', '22000M');
ini_set('upload_max_filesize', '8000M');
ini_set('max_execution_time', '90000');

class RecursosHumanosController extends Controller
{
    protected $userId;
    private $photos_path;
    protected $viewController = "superadmin.recursoshumanos";
    protected $routeController = "superadmin.recursoshumanos.index";

    /**
     * RecursosHumanosController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
        $this->photos_path = public_path('web/rrhh');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = [
            'assets/css/dataTables.bootstrap'
        ];
        $scripts = [
            'assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
        ];
        $archivos = RrhhFiles::orderBy('id', 'DESC')->get();
        return view($this->viewController . '.index', compact('styles', 'scripts', 'archivos'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function subirArchivos()
    {
        $styles = [
            'assets/js/dropzone/dropzone-custom'
        ];

        $scripts = [
            'assets/js/dropzone/dropzone',
//            'assets/js/dropzone/dropzone.min',
            'assets/js/dropzone/dropzone-config'
        ];
        return view($this->viewController . '.create', compact('styles', 'scripts', 'archivos'));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function storeArchivos(Request $request)
    {
        $photos = $request->file('file');

        if (!is_array($photos)) {
            $photos = [$photos];
        }

        if (!is_dir($this->photos_path)) {
            mkdir($this->photos_path, 0777);
        }

        for ($i = 0; $i < count($photos); $i++) {
            $photo = $photos[$i];
            $name = sha1(date('YmdHis') . str_random(30));
            $save_name = $name . '.' . $photo->getClientOriginalExtension();
            $resize_name = $name . str_random(2) . '.' . $photo->getClientOriginalExtension();

            $photo->move($this->photos_path, $save_name);

            $upload = new RrhhFiles();
            $upload->filename = $save_name;
            $upload->resized_name = $resize_name;
            $upload->original_name = basename($photo->getClientOriginalName());
            $upload->save();
        }
        return response()->json([
            'message' => 'Image saved Successfully'
        ], 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function eliminarArchivos(Request $request)
    {
        if ($request->ajax()) {
//            $filename = $request->id;
//            $archivos = RrhhFiles::where('original_name', basename($filename))->get();
            $archivo = RrhhFiles::find($request->id);

            if ($archivo == null) {
                return response()->json(['message' => 'Lo siento no encuentro el archivo.'], 400);
            }

//            foreach ($archivos as $key => $archivo) {
            $file_path = $this->photos_path . '/' . $archivo->filename;

            if (file_exists($file_path)) {
                unlink($file_path);
            }


            if (!empty($archivo)) {
                $archivo->delete();
            }

            $name = $archivo->original_name;
            $response = [
                'message' => "Se elimino el archivo <strong>" . $name . "</strong> correctamente",
                'route' => route($this->routeController)
            ];

            return response()->json(['data' => $response]);
//        }

//            return response()->json(['message' => 'Se elimino el archivo correctamente.', 'route' => route($this->routeController)], 200);
        }
    }

}
