<?php

namespace App\Http\Controllers\Superadmin\Herramientas\Reportes\Cumpleanios;

use App\Entities\Persona;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class CumpleaniosController extends Controller
{
    protected $viewController = 'superadmin.herramientas.reportes.cumpleanios';
    protected $routeController = 'superadmin.herramientas.reportes.cumpleanios.index';

    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = [
            'assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
            'assets/js/select2/select2.min',
            'assets/js/select2/select2es'];

        $meses = getMonth();
        $dateMonth = date('m');
        $personas = Persona::select('*', DB::raw('DAY(fecha_nacimiento) as dateDay'))
            ->whereMonth('fecha_nacimiento', '=', $dateMonth)
            ->orderBy('dateDay')
            ->get();

        return view($this->viewController . '.index', compact('styles', 'scripts', 'personas', 'meses'));
    }


    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function loadFilterCumpleanioMes(Request $request, $mes = null)
    {
        $month = ($mes == null) ? $request->mes : $mes;

        $personas = Persona::select('*', DB::raw('DAY(fecha_nacimiento) as dateDay'))
            ->whereMonth('fecha_nacimiento', '=', $month)
            ->orderBy('dateDay')
            ->get();

        if ($request->ajax()) {
            if ($personas != null) {
                $n = 1;

                foreach ($personas as $key => $persona) {
                    $personas[$key]->correlativo = $n;
                    $personas[$key]->foto = '<img src="' . loadPhotoProfile($persona->foto, $persona->genero) . '" class="img-avatar-cumpleanio" alt="' . $persona->apellidos_nombres . '">';
                    $personas[$key]->cargo_nombre = $persona->cargo->nombre;
                    $personas[$key]->cumpleanio = dateCarbon($persona->fecha_nacimiento);
                    $n++;
                }

                $message = 'Se cargaron los resultados de acuerdo al mes seleccionado.';
                $status = 'success';
            } else {
                $message = 'No hay resultados con el mes seleccionado.';
                $status = 'warning';
            }

            $data = [
                'message' => $message,
                'data' => $personas,
                'status' => $status
            ];

            return response()->json($data);

        } else {
            if ($personas != null) {
                $meses = getMonth();
                $cumpleanieros = [];
                $n = 1;
                foreach ($personas as $key => $persona) {
                    $cumpleanieros[$key]['N°'] = $n;
                    $cumpleanieros[$key]['NOMBRES Y APELLIDOS'] = $persona->apellidos_nombres;
                    $cumpleanieros[$key]['CARGO'] = $persona->cargo->nombre;
                    $cumpleanieros[$key]['CUMPLEAÑOS'] = dateCarbon($persona->fecha_nacimiento);
                    $cumpleanieros[$key]['DIA'] = dateCumpleanio($persona->fecha_nacimiento);
                    $n++;
                }

                $extension = 'xls';
                $nombre = "Cumpleaños Mes " . $meses[$mes];
                $strNombre = str_slug($nombre, '_');
                $nombreExcel = date('d_m_Y_H_i_s') . '_' . $strNombre;

                Excel::create($nombreExcel, function ($excel) use ($strNombre, $cumpleanieros, $nombre) {
                    $excel->sheet($strNombre, function ($sheet) use ($cumpleanieros, $nombre) {

                        $sheet->setStyle([
                            'font' => [
                                'name' => 'Arial',
                                'size' => 9
                            ]
                        ]);

                        $sheet->rows($cumpleanieros);

                        $arrayColumnA = array_keys($cumpleanieros[0]);
//                        $sheet->prependRow(1, [mb_strtoupper($nombre, 'UTF-8')]);
                        $sheet->prependRow(1, $arrayColumnA);
                        $sheet->setFreeze('A2');
                        $sheet->setAutoFilter('A1:AE1');
//                        $sheet->fromArray($cumpleanieros);
                    });
                })->export($extension);
            }
        }
    }

}
