<?php

namespace App\Http\Controllers\Superadmin\Herramientas\Listas;

use App\Entities\Lista;
use App\Entities\SubLista;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Requests\SubListaRequest;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class SubListasSubController extends Controller
{
    protected $userId;
    protected $viewController = "superadmin.herramientas.listas.sublista.sub";
    protected $routeController = "superadmin.herramientas.listas.sublista.sub.index";
    protected $routeReturnController = "superadmin.herramientas.listas.sublista.index";

    /**
     * SubListasSubController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @param null $slug
     * @param null $slugSubLista
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function index($slug = null, $slugSubLista = null)
    {
        if ($slugSubLista == null)
            return redirect()->route($this->routeReturnController, $slug);

        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min'];

//        $contenidoMenus = AdminController::tercerArbol();
        $lista = Lista::where('slug', $slug)->first();
        $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();
        $subs = SubLista::where([['sub_lista_id', $subLista->id], ['lista_id', $lista->id]])->orderBy('id', 'DESC')->get();

        return view($this->viewController . '.index', compact('styles', 'scripts', 'lista', 'subLista', 'subs'));
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $slugSubLista
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(Request $request, $slug, $slugSubLista)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();

            return view($this->viewController . '.create', compact('lista', 'subLista'));
        }
    }

    /**
     * @param SubListaRequest $request
     * @param $slug
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(SubListaRequest $request, $slug, $slugSubLista)
    {
        if ($request->ajax()) {

            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();

            $sub = new SubLista($request->all());
            $sub->created_user_id = $this->userId;
            $sub->updated_user_id = $this->userId;
            $sub->save();

            $message = 'Se creo <strong>' . $sub->nombre . '</strong> en la sub-lista <strong>' . $subLista->nombre . '</strong> correctamente';
            $response = AdminController::responseJson($message, route($this->routeController, [$slug, $slugSubLista]));

            return response()->json($response);
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $slugSubLista
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $slug, $slugSubLista, $slugSub)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();

            return view($this->viewController . '.show', compact('lista', 'subLista'));
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @param null $slugSubLista
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request, $slug, $slugSubLista, $slugSub)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();
            $sub = SubLista::where([['lista_id', $lista->id], ['sub_lista_id', $subLista->id], ['slug', $slugSub]])->first();

            return view($this->viewController . '.edit', compact('lista', 'subLista', 'sub'));
        }
    }

    /**
     * @param SubListaRequest $request
     * @param $slug
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(SubListaRequest $request, $slug, $slugSubLista, $id)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();

            $sub = SubLista::find($id);
            $sub->slug = null;
            $sub->updated_user_id = $this->userId;
            $sub->update($request->all());

            $message = 'Se actualizo <strong>' . $sub->nombre . '</strong> en la sub-lista <strong>' . $subLista->nombre . '</strong> correctamente';
//            $message = 'Se actualizo ' . $sub->nombre . ' dentro de la sub-lista ' . $subLista->nombre . ' en la lista ' . $lista->nombre . ' correctamente';
            $response = AdminController::responseJson($message, route($this->routeController, [$slug, $slugSubLista]));

            return response()->json($response);
        }
    }
}
