<?php

namespace App\Http\Controllers\Superadmin\Herramientas\Listas;

use App\Entities\Lista;
use App\Entities\SubLista;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Requests\SubListaRequest;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class ListasSubController extends Controller
{
    protected $userId;
    protected $viewController = "superadmin.herramientas.listas.sublista";
    protected $routeController = "superadmin.herramientas.listas.sublista.index";
    protected $routeReturnController = "superadmin.herramientas.listas.index";

    /**
     * ListasSubController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @param null $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function index($slug = null)
    {
        if ($slug == null)
            return redirect()->route($this->routeReturnController);

        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min'];

//        $contenidoMenus = AdminController::tercerArbol();
        $lista = Lista::where('slug', $slug)->first();
        $subListas = SubLista::where('lista_id', $lista->id)->whereNull('sub_lista_id')->orderBy('id', 'DESC')->get();
        foreach ($subListas as $key => $subLista) {
            $subListas[$key]->sub_listas_count = SubLista::where([['lista_id', $lista->id], ['sub_lista_id', $subLista->id]])->whereNotNull('sub_lista_id')->count();
        }

        return view($this->viewController . '.index', compact('styles', 'scripts', 'lista', 'subListas'));
    }

    /**
     * @param Request $request
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(Request $request, $slug)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();

            return view($this->viewController . '.create', compact('lista'));
        }
    }

    /**
     * @param SubListaRequest $request
     * @param $slug
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(SubListaRequest $request, $slug)
    {
        if ($request->ajax()) {

            $lista = Lista::where('slug', $slug)->first();

            $subLista = new SubLista($request->all());
            $subLista->created_user_id = $this->userId;
            $subLista->updated_user_id = $this->userId;
            $subLista->save();

            $message = 'Se creo la Sub-Lista <strong>' . $subLista->nombre . '</strong> correctamente';
            $response = AdminController::responseJson($message, route($this->routeController, $slug));

            return response()->json($response);
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $slugSubLista
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $slug, $slugSubLista)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();

            return view($this->viewController . '.show', compact('lista', 'subLista'));
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @param null $slugSubLista
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request, $slug, $slugSubLista = null)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();
            $subLista = SubLista::where([['lista_id', $lista->id], ['slug', $slugSubLista]])->first();

            return view($this->viewController . '.edit', compact('lista', 'subLista'));
        }
    }

    /**
     * @param SubListaRequest $request
     * @param $slug
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(SubListaRequest $request, $slug, $id)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();

            $subLista = SubLista::find($id);
            $subLista->slug = null;
            $subLista->updated_user_id = $this->userId;
            $subLista->update($request->all());

            $message = 'Se actualizo la Sub-Lista <strong>' . $subLista->nombre . '</strong> correctamente';
            $response = AdminController::responseJson($message, route($this->routeController, $slug));

            return response()->json($response);
        }
    }
}
