<?php

namespace App\Http\Controllers\Superadmin\Cargo;

use App\Entities\Area;
use App\Entities\Cargo;
use App\Entities\Sede;
use App\Http\Requests\CargoRequest;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class CargoController extends Controller
{
    protected $userId;

    /**
     * AdminController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
            'assets/js/inputmask/jasny-bootstrap.min',
            'assets/js/select2/select2.min',
            'assets/js/select2/select2es'];

        $cargos = Cargo::withCount('personas')->with('area')->orderBy('created_at', 'DESC')->get();
        foreach ($cargos as $key => $cargo) {
            $cargos[$key]['sede'] = Sede::find($cargo->area->sede_id);
        }
//        dd($cargos);

        return view('superadmin.cargos.index', compact('styles', 'scripts', 'cargos'));
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $idArea
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $slug, $idArea)
    {
        if ($request->ajax()) {

            $cargo = Cargo::where([['slug', $slug], ['area_id', $idArea]])->first();
            $area = Area::find($cargo->area_id);
            $cargo->sede_id = $area->sede_id;

            $sedes = Sede::pluck('nombre', 'id')->all();
            $areas = Area::where('sede_id', $area->sede_id)->pluck('nombre', 'id')->all();

            return view('superadmin.cargos.show', compact('sedes', 'areas', 'cargo'));
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(Request $request)
    {
        if ($request->ajax()) {

            $sedes = Sede::pluck('nombre', 'id')->all();
            $areas = [];

            return view('superadmin.cargos.create', compact('sedes', 'areas'));
        }
    }

    /**
     * @param CargoRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(CargoRequest $request)
    {
        if ($request->ajax()) {
            $area = new Cargo($request->all());
            $area->save();
            $message = 'Se creo el cargo correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.cargos.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $idArea
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request, $slug, $idArea)
    {
        if ($request->ajax()) {

            $cargo = Cargo::where([['slug', $slug], ['area_id', $idArea]])->first();
            $area = Area::find($cargo->area_id);
            $cargo->sede_id = $area->sede_id;

            $sedes = Sede::pluck('nombre', 'id')->all();
            $areas = Area::where('sede_id', $area->sede_id)->pluck('nombre', 'id')->all();

            return view('superadmin.cargos.edit', compact('sedes', 'areas', 'cargo'));
        }
    }

    /**
     * @param CargoRequest $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(CargoRequest $request, $id)
    {
        if ($request->ajax()) {
            //Find User to update
            $cargo = Cargo::find($id);
            $cargo->slug = null;
            $cargo->update($request->all());

            $message = 'Se actualizo el cargo correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.cargos.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $cargo = Cargo::find($id);
            $cargo->delete();
            $response = [
                'message' => "Se elimino correctamente"
            ];
            return response()->json(['data' => $response]);
        }
    }
}
