<?php

namespace App\Http\Controllers\Superadmin\Area;

use App\Entities\Area;
use App\Entities\Sede;
use App\Http\Requests\AreaRequest;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class AreaController extends Controller
{
    protected $userId;

    /**
     * AdminController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
            'assets/js/inputmask/jasny-bootstrap.min',
            'assets/js/select2/select2.min',
            'assets/js/select2/select2es'];

        $areas = Area::withCount('cargos')->with('sede')->orderBy('created_at', 'DESC')->get();

        return view('superadmin.areas.index', compact('styles', 'scripts', 'areas'));
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $idSede
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $slug, $idSede)
    {
        if ($request->ajax()) {

            $sedes = Sede::pluck('nombre', 'id')->all();
            $area = Area::where([['slug', $slug], ['sede_id', $idSede]])->first();

            return view('superadmin.areas.show', compact('sedes', 'area'));
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(Request $request)
    {
        if ($request->ajax()) {
            $sedes = Sede::pluck('nombre', 'id')->all();

            return view('superadmin.areas.create', compact('sedes'));
        }
    }

    /**
     * @param AreaRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(AreaRequest $request)
    {
        if ($request->ajax()) {
            $area = new Area($request->all());
            $area->save();
            $message = 'Se creo el área correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.areas.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @param $idSede
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request, $slug, $idSede)
    {
        if ($request->ajax()) {

            $sedes = Sede::pluck('nombre', 'id')->all();
            $area = Area::where([['slug', $slug], ['sede_id', $idSede]])->first();

            return view('superadmin.areas.edit', compact('sedes', 'area'));
        }
    }

    /**
     * @param AreaRequest $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(AreaRequest $request, $id)
    {
        if ($request->ajax()) {
            //Find User to update
            $area = Area::find($id);
            $area->slug = null;
            $area->update($request->all());

            $message = 'Se actualizo el área correctamente';
            messageFlash($message, 'success');
            return response()->json(
                [
                    'message' => $message,
                    'route' => route('superadmin.areas.index')
                ], 200);
        }
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(Request $request, $id)
    {
        if ($request->ajax()) {
            $area = Area::find($id);
            $area->delete();
            $response = [
                'message' => "Se elimino correctamente"
            ];
            return response()->json(['data' => $response]);
        }
    }
}
