<?php

namespace App\Http\Controllers\Soporte\Tickets;

use App\Entities\Area;
use App\Entities\Persona;
use App\Entities\Ticket;
use App\Entities\TicketEstado;
use App\Entities\TicketFoto;
use App\Entities\User;
use App\Entities\UserPersona;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class TicketsController extends Controller
{
    protected $userId;
    protected $viewController = "soporte.tickets";
    protected $routeController = "soporte.tickets.index";

    /**
     * TicketsController constructor.
     */
    public function __construct()
    {
    }

    /**
     * @return string
     */
    public function index()
    {

        return "que haces...?";
    }

    public function create()
    {

    }

    /**
     * @param Request $request
     * @param $ticket_id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $ticket_id)
    {
        $styles = ['css/plugins/steps/jquery.steps'];
        $scripts = [
            'js/plugins/steps/jquery.steps.min',
            'js/plugins/moment/moment-locales.min',
        ];

        $ticket = Ticket::with('categoriaTicket', 'tipoTicket')->where('codigo', $ticket_id)->first();
        $ticket->ticketFoto = TicketFoto::where('ticket_id', $ticket->id)->first();
        $ticket->ticketEstado = TicketEstado::where('ticket_id', $ticket->id)->first();
        if ($ticket->ticketFoto != null) {
            $ticket->ticketFoto->rutaFotoOriginal = asset('web/tickets/' . $ticket->ticketFoto->foto);
            $ticket->ticketFoto->rutaFotoThumbnail = asset('web/tickets/thumbnail/thumb-' . $ticket->ticketFoto->foto);
        }
        $userPersona = UserPersona::where('user_id', $ticket->created_user_id)->first();
        $persona = Persona::withTrashed()->with('cargo')->find($userPersona->persona_id);
        $persona->area = Area::with('sede')->find($persona->cargo->area_id);
//            $usuarioAsignar = User::where([['soporte', 1], ['id', '!=', 1]])->orderBy('last_first_name', 'ASC')->pluck('last_first_name', 'id')->all();
        $usuarioAsignar = User::where('soporte', 1)->whereNotIn('id', [1, 103])->orderBy('last_first_name', 'ASC')->pluck('last_first_name', 'id')->all(); //103 Luis Romero

        $tipoEstadoTicket = null;
        if ($ticket->ticketEstado->asignado_ticket_id == null) {
            $tipoEstadoTicket = 'asignado';
        } elseif ($ticket->ticketEstado->conincidencia_ticket_id == null) {
            $tipoEstadoTicket = 'conincidencia';
        } elseif ($ticket->ticketEstado->atendido_ticket_id == null) {
            $tipoEstadoTicket = 'atendido';
        }

        $estadoTicketNombre = route('soporte.tickets.estado', [$ticket->codigo, $tipoEstadoTicket]);
//        dd($estadoTicketNombre);

        return view($this->viewController . '.show', compact('styles', 'scripts', 'ticket', 'persona', 'usuarioAsignar', 'estadoTicketNombre'));
    }

    /**
     * @param Request $request
     * @param $codigo
     * @param $estado
     * @return \Illuminate\Http\JsonResponse|string
     */
    public function ticketEstado(Request $request, $codigo, $estado)
    {
//        dd($request->all());
        if ($estado == null) {
            return route('soporte.tickets.detalle', $codigo);
        } else {
            $ticket = Ticket::with('categoriaTicket', 'tipoTicket')->where('codigo', $codigo)->first();
            $ticketEstado = TicketEstado::with('ticket')->where('ticket_id', $ticket->id)->first();
            $estadoNew = '';
            switch ($estado) {
                case 'asignado':
                    $user = User::find($request->asignado_user_id);
                    $ticketEstado->fecha_fin_pendiente = date('Y-m-d H:i:s');
                    $ticketEstado->asignado_ticket_id = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ASIGNADO');//ASIGNADO
                    $ticketEstado->mensaje_asignado = "La atención del ticket sera brindada por el personal <strong>" . $user->last_first_name . "</strong>";
                    $ticketEstado->asignado_user_id = $request->asignado_user_id;
                    $ticketEstado->fecha_inicio_asignado = date('Y-m-d H:i:s');

                    $mensaje = "👮‍ Asignación del Ticket #" . $codigo;
                    $message = 'Se asigno el ticket #' . $codigo . ' al personal ' . $user->last_first_name . ' correctamente';
                    $estadoNew = 'conincidencia';
                    break;
                case 'conincidencia':
                    $ticketEstado->fecha_fin_asignado = date('Y-m-d H:i:s');
                    $ticketEstado->conincidencia_ticket_id = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.CONINCIDENCIA');// CONINCIDENCIA
                    $ticketEstado->mensaje_conincidencia = $request->mensaje_conincidencia;
                    $ticketEstado->fecha_inicio_conincidencia = date('Y-m-d H:i:s');

                    $mensaje = "🔥 Incidencia del Ticket #" . $codigo;
                    $message = 'Se describio el detalle de la incidencia del ticket <strong>#' . $codigo . ' </strong>';
                    $estadoNew = 'atendido';
                    break;
                case 'atendido':
                    $ticketEstado->fecha_fin_conincidencia = date('Y-m-d H:i:s');
                    $ticketEstado->atendido_ticket_id = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ATENDIDO');// ATENDIDO
                    $ticketEstado->mensaje_atendido = $request->mensaje_atendido;
                    $ticketEstado->fecha_inicio_atendido = date('Y-m-d H:i:s');
                    $ticketEstado->fecha_fin_atendido = date('Y-m-d H:i:s');

                    $mensaje = "🔥✅ Atención del Ticket #" . $codigo;
                    $message = 'Se dio por finalizado la atención del ticket ' . $codigo;

                    break;
            }
            $ticketEstado->save();

            $this->sendMailTicket($ticketEstado, $estado, $mensaje);

            $response = [
                'message' => $message,
                'route' => route('soporte.tickets.estado', [$codigo, $estadoNew])];

            return response()->json($response);
        }
    }


    private function sendMailTicket($ticketEstado, $estado, $mensaje)
    {
        $userPersona = UserPersona::where('user_id', $ticketEstado->created_user_id)->first();
        $persona = Persona::find($userPersona->persona_id);
        if ($persona != null && $persona->email != null) {

            $data_ = [];
            $data_['numeroTicket'] = $ticketEstado->ticket->codigo;
            $data_['categoria'] = $ticketEstado->ticket->categoriaTicket->nombre;
            $data_['tipo'] = $ticketEstado->ticket->tipoTicket->nombre;
            $data_['asunto'] = $ticketEstado->ticket->asunto;
            $data_['descripcion'] = $ticketEstado->ticket->descripcion;

            if ($estado == 'asignado') {
                $data_['fechaCreacion'] = $ticketEstado->fecha_inicio_asignado;
                $data_['mensajeAsignado'] = $ticketEstado->mensaje_asignado;
            }
            if ($estado == 'conincidencia') {
                $data_['fechaCreacion'] = $ticketEstado->fecha_inicio_conincidencia;
                $data_['mensajeConIncidencia'] = $ticketEstado->mensaje_conincidencia;
            }
            if ($estado == 'atendido') {
                $data_['fechaCreacion'] = $ticketEstado->ticket->fecha_fin_atendido;
                $data_['mensajeAtendido'] = $ticketEstado->mensaje_atendido;
            }
            $ticketFoto = TicketFoto::where('ticket_id', $ticketEstado->ticket->id)->first();
            $emails = [$persona->email];
            //Foto
            if ($ticketFoto != null) {
                $data_['foto'] = asset('web/tickets/' . $ticketFoto->foto);
            }

            Mail::send('admin.herramientas.email.tickets.' . $estado, $data_, function ($message) use ($mensaje, $emails) {
                $message->from('administrador@almoperations.com', 'Sistema de Tickets');
                $message->to($emails); 
                $message->subject($mensaje);
            });
        }
    }

    public function store()
    {

    }

    public function edit()
    {

    }

    public function update()
    {

    }

    /**
     * @param Request $request
     * @param $ticket_id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(Request $request, $ticket_id)
    {
        if ($request->ajax()) {
            $ticketEstado = TicketEstado::where("ticket_id", $ticket_id)->first();
            $ticketEstado->delete();


            $ticket = Ticket::find($ticket_id);
            $ticket->delete();

            $name = $ticket->codigo;
            $response = [
                'message' => "Se elimino correctamente el ticket #" . $name,
                'route' => route('soporte.index')
            ];

            return response()->json(['data' => $response]);
        }
    }
}
