<?php

namespace App\Http\Controllers\Superadmin\Tickets\ConIncidencias;

use App\Entities\Area;
use App\Entities\Persona;
use App\Entities\Ticket;
use App\Entities\TicketEstado;
use App\Entities\TicketFoto;
use App\Entities\User;
use App\Entities\UserPersona;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class ConIncidenciasController extends Controller
{
    protected $userId;
    protected $conincidenciaId;
    protected $viewController = "superadmin.tickets.conincidencias";
    protected $routeController = "superadmin.tickets.conincidencias.index";

    /**
     * PendientesController constructor.
     */
    public function __construct()
    {
        $this->conincidenciaId = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.CONINCIDENCIA');//CONINCIDENCIA
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = [
            'assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
            'assets/js/select2/select2.min',
            'assets/js/select2/select2es'];

        $tickets = TicketEstado::where('conincidencia_ticket_id', $this->conincidenciaId)->whereNull('fecha_fin_conincidencia')->orderBy('id', 'ASC')->get();
        foreach ($tickets as $key => $conincidencia) {
            $tickets[$key]->ticket = Ticket::with('categoriaTicket', 'tipoTicket')->find($conincidencia->ticket_id);
            $userPersona = UserPersona::where('user_id', $conincidencia->created_user_id)->first();
            $tickets[$key]->persona = Persona::withTrashed()->find($userPersona->persona_id);
            $tickets[$key]->asignado = User::find($conincidencia->asignado_user_id);
        }

//        dd($tickets);
        return view($this->viewController . '.index', compact('styles', 'scripts', 'tickets'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * @param Request $request
     * @param $codigo
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $codigo)
    {
        if ($request->ajax()) {
            $ticket = Ticket::with('categoriaTicket', 'tipoTicket')->where('codigo', $codigo)->first();
            $ticket->ticketFoto = TicketFoto::where('ticket_id', $ticket->id)->first();
            if ($ticket->ticketFoto != null) {
                $ticket->ticketFoto->rutaFotoOriginal = asset('web/tickets/' . $ticket->ticketFoto->foto);
                $ticket->ticketFoto->rutaFotoThumbnail = asset('web/tickets/thumbnail/thumb-' . $ticket->ticketFoto->foto);
            }
            $userPersona = UserPersona::where('user_id', $ticket->created_user_id)->first();
            $persona = Persona::withTrashed()->with('cargo')->find($userPersona->persona_id);
            $persona->area = Area::with('sede')->find($persona->cargo->area_id);

            return view($this->viewController . '.show', compact('ticket', 'persona'));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Request $request, $id)
    {
        $ticketEstado = TicketEstado::with('ticket')->where('ticket_id', $id)->first();
        $ticketEstado->fecha_fin_conincidencia = date('Y-m-d H:i:s');
        $ticketEstado->atendido_ticket_id = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ATENDIDO');// ATENDIDO
        $ticketEstado->mensaje_atendido = $request->mensaje_atendido;
        $ticketEstado->fecha_inicio_atendido = date('Y-m-d H:i:s');
        $ticketEstado->save();

        $message = 'Se describio el detalle de la incidencia del ticket <strong>' . $ticketEstado->ticket->codigo . ' </strong>';
        notifyFlash($message, 'success');
        $response = [
            'route' => route($this->routeController)
        ];
        return response()->json($response);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
