<?php

namespace App\Http\Controllers\Soporte;

use App\Entities\Persona;
use App\Entities\Ticket;
use App\Entities\TicketEstado;
use App\Entities\User;
use App\Entities\UserPersona;
use Carbon\Carbon;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SoporteController extends Controller
{
    protected $userId;
    protected $viewController = "soporte";
    protected $routeController = "soporte.index";

    /**
     * SoporteController constructor.
     */
    public function __construct()
    {

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $styles = [
            'css/plugins/daterangepicker/daterangepicker-bs3',
            'css/plugins/select2/select2.min',
            'js/plugins/sweetalert2/dist/sweetalert2.min'
        ];

        $scripts = [
//            'js/plugins/fullcalendar/moment.min',
            'js/plugins/moment/moment-locales.min',
            'js/plugins/daterangepicker/daterangepicker',
            'js/plugins/select2/select2.full.min',
            'js/plugins/sweetalert2/dist/sweetalert2.min'
        ];

        $tickets = Ticket::get();
        $ticketsCount = Ticket::count();
        $reportEasyTickets = [];
        $pendiente = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.PENDIENTE');//PENDIENTE
        $asignados = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ASIGNADO');//ASIGNADO
        $conIncidencias = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.CONINCIDENCIA');//CONINCIDENCIA
        $atendidos = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ATENDIDO');//ATENDIDO

        $today = Carbon::today()->toDateString();
        $monthDefault = Carbon::createFromFormat('Y-m-d', $today)->format('m');

        $firstDay = date('01-m-Y');
        $lastDay = date("t-m-Y");

        $countPendientes = TicketEstado::where('pendiente_ticket_id', $pendiente)->whereNull('fecha_fin_pendiente')->whereMonth('created_at', '=', $monthDefault)->orderBy('id', 'DESC')->count();
        $countAsignados = TicketEstado::where('asignado_ticket_id', $asignados)->whereNull('fecha_fin_asignado')->whereMonth('created_at', '=', $monthDefault)->orderBy('id', 'DESC')->count();
        $countConIncidencias = TicketEstado::where('conincidencia_ticket_id', $conIncidencias)->whereNull('fecha_fin_conincidencia')->whereMonth('created_at', '=', $monthDefault)->orderBy('id', 'DESC')->count();
        $countAtendidos = TicketEstado::where('atendido_ticket_id', $atendidos)->whereMonth('created_at', '=', $monthDefault)->orderBy('id', 'DESC')->count();

        $ticketsPendientes = TicketEstado::where('pendiente_ticket_id', $pendiente)->whereNull('fecha_fin_pendiente')->orderBy('id', 'DESC')->get();
        foreach ($ticketsPendientes as $key => $ticketsPendiente) {
            $ticketsPendientes[$key]->ticket = Ticket::with('categoriaTicket', 'tipoTicket')->find($ticketsPendiente->ticket_id);
            $userPersona = UserPersona::where('user_id', $ticketsPendiente->created_user_id)->first();
            $ticketsPendientes[$key]->persona = Persona::withTrashed()->find($userPersona->persona_id);
        }

        if ($tickets != null) {
            foreach ($tickets as $key => $ticket) {
                $reportEasyTickets['pendientes']['cantidad'] = $countPendientes;
                $reportEasyTickets['pendientes']['porcentaje'] = formatPrice((100 * $countPendientes) / $ticketsCount);
                $reportEasyTickets['asignados']['cantidad'] = $countAsignados;
                $reportEasyTickets['asignados']['porcentaje'] = formatPrice((100 * $countAsignados) / $ticketsCount);
                $reportEasyTickets['conIncidencias']['cantidad'] = $countConIncidencias;
                $reportEasyTickets['conIncidencias']['porcentaje'] = formatPrice((100 * $countConIncidencias) / $ticketsCount);
                $reportEasyTickets['atendidos']['cantidad'] = $countAtendidos;
                $reportEasyTickets['atendidos']['porcentaje'] = formatPrice((100 * $countAtendidos) / $ticketsCount);
            }
        }

        $ticketEstados = TicketEstado::with('ticket')->orderBy('id', 'DESC')->skip(0)->take(10)->get();
        
        foreach ($ticketEstados as $key => $ticketEstado) {
            $ticketEstados[$key]->estadoTicket = estadoTicket($ticketEstado->pendiente_ticket_id, $ticketEstado->asignado_ticket_id, $ticketEstado->conincidencia_ticket_id, $ticketEstado->atendido_ticket_id);
            $ticketEstados[$key]->estadoTicketFecha = estadoTicketFecha($ticketEstado->fecha_inicio_pendiente, $ticketEstado->fecha_inicio_asignado, $ticketEstado->fecha_inicio_conincidencia, $ticketEstado->fecha_fin_atendido);
            $ticketEstados[$key]->tecnico = ($ticketEstado->asignado_user_id == null) ? null : User::withTrashed()->find($ticketEstado->asignado_user_id);
            $userPersona = UserPersona::where('user_id', $ticketEstado->created_user_id)->first();
            $ticketEstados[$key]->persona = Persona::withTrashed()->find($userPersona->persona_id);
            $ticketEstados[$key]->ticket = Ticket::where('id', $ticketEstado->ticket_id)->first();
        }

        $estadoTickets = listaNombre('estado-tickets');

        return view($this->viewController . '.index', compact('styles', 'scripts', 'ticketsCount', 'reportEasyTickets', 'ticketsPendientes', 'firstDay', 'lastDay', 'ticketEstados', 'estadoTickets'));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function filtroTickets(Request $request)
    {
        $pendiente = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.PENDIENTE');//PENDIENTE
        $asignados = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ASIGNADO');//ASIGNADO
        $conIncidencias = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.CONINCIDENCIA');//CONINCIDENCIA
        $atendidos = getInfoConstanteId('listas.ESTADOTICKETS', 'estadoTickets.ATENDIDO');//ATENDIDO
        if ($request->codigo != null) {
            $ticket = Ticket::where('codigo', $request->codigo)->first();
            if ($ticket != null) {
                $estadoTicket = TicketEstado::with('ticket')->where('ticket_id', $ticket->id)->first();
                $ticket->ticketEstado = $estadoTicket;
                $ticket->estadoTicket = estadoTicket($estadoTicket->pendiente_ticket_id, $estadoTicket->asignado_ticket_id, $estadoTicket->conincidencia_ticket_id, $estadoTicket->atendido_ticket_id);
                $ticket->estadoTicketFecha = estadoTicketFecha($estadoTicket->fecha_inicio_pendiente, $estadoTicket->fecha_inicio_asignado, $estadoTicket->fecha_inicio_conincidencia, $estadoTicket->fecha_fin_atendido);
                $ticket->estadoTicketFechaFormat = fechaEstadoTicket(estadoTicketFecha($estadoTicket->fecha_inicio_pendiente, $estadoTicket->fecha_inicio_asignado, $estadoTicket->fecha_inicio_conincidencia, $estadoTicket->fecha_fin_atendido));
                $ticket->tecnico = ($estadoTicket->asignado_user_id == null) ? null : tecnicoTicket(User::withTrashed()->find($estadoTicket->asignado_user_id));
                $userPersona = UserPersona::where('user_id', $estadoTicket->created_user_id)->first();
                $ticket->persona = Persona::withTrashed()->find($userPersona->persona_id);
                $ticket->urlDetalle = route('soporte.tickets.detalle', $request->codigo);
                $ticket->urlEliminar = ($request->estado_ticket_id != $atendidos && $request->estado_ticket_id != null) ? route('soporte.tickets.delete', $estadoTicket->ticket->id) : null;

                $message = "Se encontro ticket y se muestra la información";
                $status = 1;
            } else {
                $message = "No existe ticket con el código ingresado";
                $status = 0;
            }

            $response = [
                'message' => $message,
                'estado' => $status,
                'ticket' => $ticket
            ];

            return response()->json($response);
        } else {
            $query = TicketEstado::with('ticket');
            if ($request->estado_ticket_id != null || $request->estado_ticket_id != "") {

                switch ($request->estado_ticket_id) {
                    case $pendiente:
                        $query->where('pendiente_ticket_id', $pendiente)->whereNull('asignado_ticket_id');
                        break;
                    case $asignados:
                        $query->where('asignado_ticket_id', $asignados)->whereNull('conincidencia_ticket_id');
                        break;
                    case $conIncidencias:
                        $query->where('conincidencia_ticket_id', $conIncidencias)->whereNull('atendido_ticket_id');
                        break;
                    case $atendidos:
                        $query->where('atendido_ticket_id', $atendidos);
                        break;
                }
            }

            $ticketEstados = $query->whereBetween('fecha_inicio_pendiente', [formatDate($request->desde), formatDate($request->hasta)])->orderBy('id', 'DESC')->get();

            if (count($ticketEstados)) {
                foreach ($ticketEstados as $key => $ticketEstado) {
                    $ticketEstados[$key]->estadoTicket = estadoTicket($ticketEstado->pendiente_ticket_id, $ticketEstado->asignado_ticket_id, $ticketEstado->conincidencia_ticket_id, $ticketEstado->atendido_ticket_id);
                    $ticketEstados[$key]->estadoTicketFecha = estadoTicketFecha($ticketEstado->fecha_inicio_pendiente, $ticketEstado->fecha_inicio_asignado, $ticketEstado->fecha_inicio_conincidencia, $ticketEstado->fecha_fin_atendido);
                    $ticketEstados[$key]->estadoTicketFechaFormat = fechaEstadoTicket(estadoTicketFecha($ticketEstado->fecha_inicio_pendiente, $ticketEstado->fecha_inicio_asignado, $ticketEstado->fecha_inicio_conincidencia, $ticketEstado->fecha_fin_atendido));
                    $ticketEstados[$key]->tecnico = ($ticketEstado->asignado_user_id == null) ? null : tecnicoTicket(User::withTrashed()->find($ticketEstado->asignado_user_id));
                    $userPersona = UserPersona::where('user_id', $ticketEstado->created_user_id)->first();
                    $ticketEstados[$key]->persona = Persona::withTrashed()->find($userPersona->persona_id);
                    $ticketEstados[$key]->urlDetalle = route('soporte.tickets.detalle', $ticketEstado->ticket->codigo);
                    $ticketEstados[$key]->urlEliminar = ($request->estado_ticket_id != $atendidos) ? route('soporte.tickets.delete', $ticketEstado->ticket->id) : null;
                    $ticketEstados[$key]->ticket = Ticket::where('id', $ticketEstado->ticket_id)->first();
                }
                $message = "Se lista la información solicitada";
                $status = 1;
            } else {
                $message = "No hay información seleccionada";
                $status = 0;
            }

            $response = [
                'message' => $message,
                'estado' => $status,
                'tickets' => $ticketEstados
            ];
            return response()->json($response);
        }
    }

}
