<?php

namespace App\Http\Controllers\Soporte\Herramientas\Listas;

use App\Entities\Lista;
use App\Entities\SubLista;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Requests\SubListaRequest;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class ListasController extends Controller
{
    protected $userId;
    protected $viewController = "soporte.herramientas.listas";
    protected $routeController = "soporte.herramientas.listas.index";

    /**
     * ListasController constructor.
     */
    public function __construct()
    {
        $this->userId = Session::get('usuario.id');

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $styles = ['assets/css/dataTables.bootstrap'];
        $scripts = ['assets/js/datatable/jquery.dataTables.min',
            'assets/js/datatable/ZeroClipboard',
            'assets/js/datatable/dataTables.tableTools.min',
            'assets/js/datatable/dataTables.bootstrap.min',
            'assets/js/select2/select2.min',
            'assets/js/select2/select2es'];

        //$contenidoMenus = AdminController::segundoArbol();
        $listas = Lista::orderBy('id', 'DESC')->get();
        foreach ($listas as $key => $lista) {
            $listas[$key]->sub_listas_count = SubLista::whereNull('sub_lista_id')->where('lista_id', $lista->id)->count();
        }

        return view($this->viewController . '.index', compact('styles', 'scripts', 'listas'));
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(Request $request)
    {
        if ($request->ajax()) {
            return view($this->viewController . '.create');
        }
    }

    /**
     * @param SubListaRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(SubListaRequest $request)
    {
        if ($request->ajax()) {

            $lista = new Lista($request->all());
            $lista->created_user_id = $this->userId;
            $lista->updated_user_id = $this->userId;
            $lista->save();

            $message = 'Se creó la lista <strong>' . $lista->nombre . '</strong> correctamente';
            $response = AdminController::responseJson($message, route($this->routeController));
            return response()->json($response);
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(Request $request, $slug)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();

            return view($this->viewController . '.show', compact('lista'));
        }
    }

    /**
     * @param Request $request
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request, $slug)
    {
        if ($request->ajax()) {
            $lista = Lista::where('slug', $slug)->first();

            return view($this->viewController . '.edit', compact('lista'));
        }
    }

    /**
     * @param SubListaRequest $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(SubListaRequest $request, $id)
    {
        if ($request->ajax()) {
            $lista = Lista::find($id);
            $lista->slug = null;
            $lista->updated_user_id = $this->userId;
            $lista->update($request->all());

            $message = "Se actualizo la lista <strong>" . $lista->nombre . "</strong> correctamente";
            $response = AdminController::responseJson($message, route($this->routeController));

            return response()->json($response);
        }
    }


}
