<?php

namespace App\Http\Controllers\Soporte\Herramientas;

use App\Entities\Area;
use App\Entities\Cargo;
use App\Entities\Persona;
use App\Entities\Sede;
use App\Entities\User;
use App\Entities\UserPersona;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

ini_set('memory_limit', '22000M');
ini_set('upload_max_filesize', '8000M');
ini_set('max_execution_time', '90000');

class HerramientasController extends Controller
{
    protected $file = 'import/personal.xlsx';
    protected $viewController = 'soporte.herramientas';
    protected $routeController = 'soporte.herramientas.index';

    /**
     * HerramientasController constructor.
     */
    public function __construct()
    {

    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        return view($this->viewController . '.index');
    }

    /**
     * @return mixed
     */
    public function importSede()
    {
        Excel::load('import/sede.csv', function ($reader) {
            foreach ($reader->get() as $sede) {
                $imports = Sede::where('nombre', $sede->sede)->first();
                if (!$imports) {
                    /**
                     * Create Sede
                     */
                    Sede::create([
                        'nombre' => $sede->sede
                    ]);
                }
            }
        });
//        }, 'ISO-8859-1');

        return Sede::all();
    }

    /**
     * @return mixed
     */
    public function importArea()
    {
        Excel::load($this->file, function ($reader) {
            $results = $reader->get();
            foreach ($results as $area) {

                $sede = Sede::where("nombre", $area->sede)->first();
                $imports = Area::where([['nombre', $area->area], ['sede_id', $sede->id]])->first();
                if (!$imports) {
                    /**
                     * Create Area
                     */
                    Area::create([
                        'nombre' => trim($area->area),
                        'sede_id' => $sede->id
                    ]);
                }
            }
        });
//        }, 'ISO-8859-1');

        return Area::all();
    }

    /**
     * @return mixed
     */
    public function importCargo()
    {
        Excel::load($this->file, function ($reader) {

            foreach ($reader->get() as $cargo) {
                $area = Area::areaSede($cargo->area, $cargo->sede);
                $imports = Cargo::where([['nombre', $cargo->cargo], ['area_id', $area->id]])->first();
                if (!$imports) {
                    /**
                     * Create Cargo
                     */
                    Cargo::create([
                        'nombre' => trim($cargo->cargo),
                        'area_id' => $area->id
                    ]);
                }
            }

        });

        return Cargo::all();
    }

    /**
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function importPersonal()
    {
        Excel::load($this->file, function ($reader) {

            foreach ($reader->get() as $persona) {
                $dni = ($persona->extranjero == 1) ? strpad(trim($persona->dni), 9) : strpad(trim($persona->dni), 8);
                $imports = Persona::where('dni', $dni)->first();
                if (!$imports) {
                    /**
                     * Create Persona
                     */


                    $personal = new Persona();
                    $personal->dni = $dni;
                    $personal->apellidos_nombres = trim($persona->apellidos_nombres);
                    $personal->cargo_id = Cargo::cargoAreaSede(trim($persona->cargo), trim($persona->area), trim($persona->sede))->id;
                    $personal->fecha_nacimiento = formatDateImport($persona->fecha_nacimiento);
                    $personal->genero = $persona->genero;
                    $personal->save();

                    /**
                     * Create new user
                     */
                    $user = new User();
                    $user->username = $dni;
                    $user->last_first_name = trim($persona->apellidos_nombres);
                    $user->password = $dni;
                    $user->role_id = 3;
                    $user->remember_token = str_random(10);
                    $user->save();

                    /**
                     * Create new UserPersona
                     */
                    $userPersona = new UserPersona();
                    $userPersona->user_id = $user->id;
                    $userPersona->persona_id = $personal->id;
                    $userPersona->save();

                }

            }
        });

        return Persona::all();
    }
}
