<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SuperAdminController extends Controller
{
    /**
     * Where to redirect users after login / registration.
     *
     * @var string
     */
    protected $redirectTo = '/superadmin';

    protected $guard = 'superadmin';

    /**
     * SuperAdminController constructor.
     */
    public function __construct()
    {
        $this->middleware('superadmin', ['except' => ['logout', 'getLogin', 'postLogin']]);
    }

    public function getLogin()
    {
        if (Auth::guard($this->guard)->check()) {
            return $this->dashboard();
        }
        return $this->showLoginForm();
    }

    /**
     * Show the application login form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLoginForm()
    {
        $view = "auth.authenticate";

        if (view()->exists($view)) {
            return view($view);
        }
        return view('superadmin.acceso.login');
    }

    /**
     * Handle a login request to the application.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function postLogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'username' => 'required',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()
                ->route('superadmin.login')
                ->with('errors', ['message' => 'Necesita completar los campos', 'type' => 'warning']);
        }

        $credentials = [
            'username' => $request->username,
            'password' => $request->password,
            'deleted_at' => null
        ];

        if (Auth::guard($this->guard)->attempt($credentials, true)) {
            $user = Auth::guard($this->guard)->user();
            if ($user->admin == 1) {
                Session::put('guard', $this->guard);
                $names = nameUser($user->first_name, $user->last_name);
                Session::put('usuario', [
                    'id' => $user->id,
                    'names' => $names
                ]);
            } else {
                $this->logout();
            }

            return redirect($this->redirectTo);
        } else {
            return redirect()
                ->route('superadmin.login')
                ->with('errors', ['message' => 'Datos ingresados son incorrectos', 'type' => 'danger']);
        }
    }

    /**
     * Get the login username to be used by the controller.
     *
     * @return string
     */
    public function loginUsername()
    {
        return property_exists($this, 'username') ? $this->username : 'username';
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function dashboard()
    {
        return redirect()->route('superadmin.index');
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function logout()
    {
        Session::flush();
        Auth::guard($this->guard)->logout();
        return redirect()->route('superadmin.login');
    }
}
