<?php

namespace App\Http\Controllers\Api\V1\Mobile;

use App\Entities\Persona;
use App\Entities\User;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class MobileController extends Controller
{
    public function __construct()
    {
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        return response()->json(['results' => null]);
    }

    /**
     * @param Request $request
     * @param $dni
     * @return \Illuminate\Http\JsonResponse
     */
    public function persona(Request $request, $dni)
    {
        if (isset($dni)) {
            if (strlen($dni) == 8) {
                $dataPersona = [];
                $persona = Persona::withTrashed()->where('dni', $dni)->first();
                if ($persona != null) {
                    $dataPersona['apellidos_nombres'] = $persona->apellidos_nombres;
                    $dataPersona['celular_1'] = $persona->telefono_personal;
                    $dataPersona['estado_persona'] = ($persona->deleted_at == null) ? "ACTIVO" : "CESE";
                    $response = [
                        'data' => $dataPersona,
                        'message' => 'Se carga la siguiente información',
                        'status' => 200
                    ];
                    return response()->json($response);
                } else {
                    $response = [
                        'data' => null,
                        'message' => 'No se encontró al trabajador que busca',
                        'status' => 402
                    ];
                    return response()->json($response, 422);
                }
            } else {
                $response = [
                    'data' => null,
                    'message' => 'D.N.I debe tener 8 dígitos',
                    'status' => 402
                ];
                return response()->json($response, 422);
            }
        } else {
            $response = [
                'data' => null,
                'message' => 'Ingrese su D.N.I',
                'status' => 402
            ];
            return response()->json($response, 422);
        }
    }
}
