<?php

namespace App\Http\Controllers\Admin\Sede;

use App\Entities\Area;
use App\Entities\Cargo;
use App\Entities\Persona;
use App\Entities\Sede;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class SedeController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $sedes = Sede::all();

        return view('admin.sedes.index', compact('sedes'));
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show($slug)
    {
        $sede = Sede::where('slug', $slug)->first();
        $areas = Area::with('sede')->where('sede_id', $sede->id)->get();

        return view('admin.sedes.show', compact('sede', 'areas'));
    }

    /**
     * @param $slug
     * @param null $slugarea
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function area($slug, $slugarea = null)
    {
        if ($slugarea == null) {
            return redirect()->route('admin.sede.detalle', $slug);
        }
//        $slugSede = $slug;
        $slugArea = $slugarea;
        $area = Area::where('slug', $slugarea)->first();
        $cargos = Cargo::with('area')->where('area_id', $area->id)->get();
        $personas = [];

        foreach ($cargos as $key => $cargo) {
            $gentes = Persona::where('cargo_id', $cargo->id)->get();
            foreach ($gentes as $jey => $gente) {
                $personas[] = $gente;
            }
        }

        return view('admin.sedes.areas.index', compact('slug', 'slugArea', 'cargos', 'personas'));
    }

    /**
     * @param $slug
     * @param $slugarea
     * @param null $slugpersona
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function persona($slug, $slugarea, $slugpersona = null)
    {
        if ($slugpersona == null) {
            return redirect()->route('admin.sede.area', [$slug, $slugarea]);
        }

        $slugSede = $slug;
        $slugArea = $slugarea;
        $persona = Persona::with('cargo')->where('slug', $slugpersona)->first();
        $persona->fechaNacimiento = $persona->fecha_nacimiento;
        $persona->fecha_nacimiento = dateCarbon($persona->fecha_nacimiento);
        $persona->area = Area::find($persona->cargo->area_id);
        $persona->sede = Sede::find($persona->area->sede_id);
        $persona->gener = $persona->genero;
        $persona->genero = ($persona->genero == "M") ? "Masculino" : "Femenino";


        return view('admin.sedes.areas.personas.index', compact('slugSede', 'slugArea', 'cargos', 'persona'));
    }

    /**
     * @param $slug
     * @param $slugarea
     * @param null $slugpersona
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function personaCompanieros($slug, $slugarea, $slugpersona = null)
    {
        $slugArea = $slugarea;
        $area = Area::where('slug', $slugarea)->first();
        $cargos = Cargo::with('area')->where('area_id', $area->id)->get();
        $persona = Persona::with('cargo')->where('slug', $slugpersona)->first();
        $persona->fechaNacimiento = $persona->fecha_nacimiento;
        $persona->gener = $persona->genero;
        $personas = [];

        foreach ($cargos as $key => $cargo) {
            $gentes = Persona::where([['cargo_id', $cargo->id], ['id', '!=', $persona->id]])->get();
            foreach ($gentes as $jey => $gente) {
                $personas[] = $gente;
            }
        }

        return view('admin.sedes.areas.personas.companieros', compact('slug', 'slugArea', 'cargos', 'persona', 'personas'));
    }

}
