<?php

namespace App\Http\Controllers\Admin\RecursosHumanos;

use App\Entities\RrhhFiles;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class RecursosHumanosController extends Controller
{
    protected $userId;
    protected $viewController = "admin.recursoshumanos";
    protected $routeController = "admin.recursoshumanos.index";

    /**
     * TicketsController constructor.
     */
    public function __construct()
    {
        $this->userId = Auth::guard('admin')->user();
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $archivos = RrhhFiles::orderBy('id', 'DESC')->get();

        return view($this->viewController . ".index", compact('archivos'));
    }
}
