<?php

namespace App\Http\Controllers\Admin\Noticias;

use App\Http\Controllers\Admin\Ajax\AjaxController;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class NoticiasController extends Controller
{
    protected $viewController = "admin.noticias";
    protected $routeController = "admin.noticias.index";

    /**
     * NoticiasController constructor.
     */
    public function __construct()
    {

    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $scripts = [
            'support/js/plugins/masonary/masonry.pkgd.min'
        ];

        return view($this->viewController . '.index', compact('scripts'));
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function detalle($slug)
    {
        $scripts = ['vendors/bower_components/moment/min/moment-with-locales.min'];

        return view($this->viewController . '.show', compact('scripts', 'slug'));
    }

}
