<?php

namespace App\Http\Controllers\Admin\Favorito;

use App\Entities\Favorito;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FavoritoController extends Controller
{
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $favoritos = Favorito::with('user', 'persona')
            ->where('user_id', Auth::guard('admin')->user()->id)->get();

        return view('admin.favorito.index', compact('favoritos'));
    }

    /**
     * @param Request $request
     * @param $idPersona
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request, $idPersona)
    {
        if ($request->ajax()) {
            $favorito = new Favorito();
            $favorito->user_id = Auth::guard('admin')->user()->id;
            $favorito->persona_id = $idPersona;
            $favorito->save();

            return response()->json(
                [
                    'message' => 'Se guardo como favorito'
                ], 200);
        }
    }
}
