<?php

namespace App\Http\Controllers\Admin\Area;

use App\Entities\Area;
use App\Entities\Cargo;
use App\Entities\Persona;
use App\Entities\Sede;
use App\Entities\UserPersona;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AreaController extends Controller
{

    protected $userId;

    /**
     * AreaController constructor.
     */
    public function __construct()
    {
//        $this->userId = Auth::guard('admin')->user()->id;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $userPersona = UserPersona::where('user_id', Auth::guard('admin')->user()->id)->first();
        $persona = Persona::with('cargo')->find($userPersona->persona_id);
        $area = Area::with('sede')->find($persona->cargo->area_id);

        $areas = Area::where('sede_id', $area->sede->id)->get();

        return view('admin.areas.index', compact('styles', 'scripts', 'areas'));
    }

    /**
     * @param $slug
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show($slug)
    {
        $area = Area::where('slug', $slug)->first();
        $cargos = Cargo::with('area')->where('area_id', $area->id)->get();
        $personas = [];

        foreach ($cargos as $key => $cargo) {
            $gentes = Persona::where('cargo_id', $cargo->id)->get();
            foreach ($gentes as $jey => $gente) {
                $personas[] = $gente;
            }
        }

        return view('admin.areas.show', compact('slug', 'cargos', 'personas'));
    }

    /**
     * @param $slug
     * @param null $slugpersona
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function persona($slug, $slugpersona = null)
    {
        if ($slugpersona == null) {
            return redirect()->route('admin.area.detalle', $slug);
        }

        $area = Area::where('slug', $slug)->first();
        $cargos = Cargo::with('area')->where('area_id', $area->id)->get();
        $persona = Persona::where('slug', $slugpersona)->first();
        $persona->fechaNacimiento = $persona->fecha_nacimiento;
        $persona->fecha_nacimiento = dateCarbon($persona->fecha_nacimiento);
        $persona->area = Area::find($persona->cargo->area_id);
        $persona->sede = Sede::find($persona->area->sede_id);
        $persona->gener = $persona->genero;
        $persona->genero = ($persona->genero == "M") ? "Masculino" : "Femenino";


        return view('admin.areas.personas.index', compact('slug', 'cargos', 'persona'));
    }

    /**
     * @param $slug
     * @param null $slugpersona
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function personaCompanieros($slug, $slugpersona = null)
    {
        $area = Area::where('slug', $slug)->first();
        $cargos = Cargo::with('area')->where('area_id', $area->id)->get();
        $persona = Persona::with('cargo')->where('slug', $slugpersona)->first();
        $persona->fechaNacimiento = $persona->fecha_nacimiento;
        $persona->gener = $persona->genero;
        $personas = [];

        foreach ($cargos as $key => $cargo) {
            $gentes = Persona::where([['cargo_id', $cargo->id], ['id', '!=', $persona->id]])->get();
            foreach ($gentes as $jey => $gente) {
                $personas[] = $gente;
            }
        }

        return view('admin.areas.personas.companieros', compact('slug', 'cargos', 'persona', 'personas'));
    }
}
