<?php

namespace App\Http\Controllers\Admin\Ajax;

use App\Entities\SubLista;
use App\Entities\Ticket;
use App\Entities\TicketEstado;
use App\Entities\TicketFoto;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AjaxController extends Controller
{
//    protected $urlWpCablePeru = 'http://192.168.2.217/cableperu/wp-json/wp/v2/'; //Local
    protected $urlWpCablePeru = 'https://cableperu.pe/wp-json/wp/v2/'; // Produccion
//    protected $urlWpCable = 'http://192.168.2.217/cableperu/';

    /**
     * @return null
     */
    public function index()
    {
        return null;
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function categoriaTickets(Request $request)
    {
        $categoriaTicket = SubLista::where('sub_lista_id', $request->sub_lista_id)->orderBy('nombre', 'ASC')->pluck('id', 'nombre')->all();
        $response = [
            'data' => $categoriaTicket
        ];
        return response()->json($response);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function buscarTicket(Request $request)
    {
        $user = Auth::guard('admin')->user();
        $codigo = $request->codigo;
        $response = null;
//        $ticket = Ticket::with('categoriaTicket', 'tipoTicket')->where([['codigo', $codigo], ['created_user_id', $user->id]])->first();
        $ticket = Ticket::with('categoriaTicket', 'tipoTicket')->where('codigo', $codigo)->first();
        if ($ticket != null) {
            if ($ticket->created_user_id == $user->id) {
                $ticket->ticketEstado = TicketEstado::where('ticket_id', $ticket->id)->first();
                $ticket->ticketFotos = TicketFoto::where('ticket_id', $ticket->id)->get();
//                $response = $ticket;
                $response = [
                    'data' => $ticket,
                    'message' => 'Se carga la siguiente información'
                ];
            } else {
                $response = [
                    'data' => null,
                    'message' => 'Número de ticket ingresado no fue generado por usted'
                ];
            }
        } else {
            $response = [
                'data' => null,
                'message' => 'No se encuentra número de ticket ingresado'
            ];
        }

        return response()->json($response);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function dircorpNoticias()
    {
        $dircorpNoticias = $this->urlWpCablePeru . 'dircorp-noticias-api';
        $noticias = json_decode(file_get_contents($dircorpNoticias), TRUE);

        return response()->json(['data' => $noticias]);

    }

    /**
     * @param $slug
     * @return \Illuminate\Http\JsonResponse
     */
    public function dircorpNoticiasDetalle($slug)
    {
        $route = $this->urlWpCablePeru . 'dircorp-noticias-api?slug=' . $slug;
        $noticiaDecode = json_decode(file_get_contents($route), TRUE);

        $dircorpNoticias = $this->urlWpCablePeru . 'dircorp-noticias-api';
        $noticias = json_decode(file_get_contents($dircorpNoticias), TRUE);

        if ($noticiaDecode != null) {
            $response = [
                'noticia' => $noticiaDecode[0],
                'noticias' => $noticias,
            ];
        } else {
            $response = [
                'noticia' => null,
                'noticias' => null,
                'route' => route('admin.noticias.index')
            ];
        }

        return response()->json($response);
    }
}
