<?php

namespace App\Http\Controllers\Admin;

use App\Entities\Abonado;
use App\Entities\Favorito;
use App\Entities\Persona;
use App\Entities\User;
use App\Entities\UserPersona;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class AdminController extends Controller
{
    protected $userId;

    /**
     * AdminController constructor.
     */
    public function __construct()
    {
//        $this->userId = Session::get('usuario.id');
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        return view('admin.index');
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function password(Request $request)
    {
        if ($request->ajax()) {
            $user = User::find(Auth::guard('admin')->user()->id);

            return view('admin.herramientas.cambiarpassword.password', compact('user'));
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function changePassword(Request $request)
    {
        if ($request->ajax()) {
            if ($request->password != "") {
                $user = User::find(Auth::guard('admin')->user()->id);
                $user->password = $request->password;
                $user->save();

//                $message = 'Se actualizo la información de contacto correctamente';
//                messageFlash($message, 'success');

                messageFlash('La contraseña se MODIFICO correctamente', 'success');
            } else messageFlash('La contraseña NO PUDO MODIFICARSE', 'danger', 'fa-times');
            return response()->json(['data' => 'result']);
        }
    }

    /**
     * @param Request $request
     * @param $name
     * @return \Illuminate\Http\JsonResponse
     */
    public function buscarPersona(Request $request, $name)
    {
        if ($request->ajax()) {
            if (isset($name)) {
                $user_id = Auth::guard('admin')->user()->id;
                $userPersona = UserPersona::where('user_id', $user_id)->first();
                $personas = Persona::where('id', '!=', $userPersona->persona_id)
                    ->where('apellidos_nombres', 'like', '%' . $name . '%')
                    ->get();

                foreach ($personas as $key => $persona) {
                    $personas[$key]['foto'] = loadPhotoProfile($persona->foto, $persona->genero);
                    $personas[$key]['fotoError'] = asset('img/profile/' . (($persona->genero == 'M') ? "man" : "women") . ".png");
                    $personas[$key]['sedeAreaCargo'] = Persona::sedeAreaCargo($persona->cargo_id);
                    $personas[$key]['favorito'] = Favorito::where([['user_id', $user_id], ['persona_id', $persona->id]])->first();
                }

                return response()->json(['data' => $personas]);
            }
            return response()->json(null);
        }
    }

    /**
     * @param $message
     * @param $route
     * @return array
     */
    public static function responseJson($message, $route)
    {
        notifyFlash($message, 'success');

        return $array = [
            'message' => $message,
            'route' => $route
        ];
    }
}
