<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;

class UserPersona extends Model
{
    protected $table = "user_personas";

    /**
     * @var array
     */
    protected $fillable = [
        'user_id', 'persona_id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class)->withTrashed();
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function persona()
    {
        return $this->belongsTo(Persona::class)->withTrashed();
    }

}
