<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;

class TicketFoto extends Model
{
    protected $table = 'ticket_fotos';
    protected $dates = ['deleted_at'];
    protected $fillable = [
        'foto', 'ticket_id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function ticket()
    {
        return $this->belongsTo(Ticket::class, 'ticket_id');
    }
}
