<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TicketEstado extends Model
{
    use SoftDeletes;
    protected $table = 'ticket_estados';
    protected $dates = ['deleted_at'];

    protected $fillable = [
        'pendiente_ticket_id', 'mensaje_pendiente', 'fecha_inicio_pendiente', 'fecha_fin_pendiente',
        'asignado_ticket_id', 'mensaje_asignado', 'asignado_user_id', 'fecha_inicio_asignado', 'fecha_fin_asignado',
        'conincidencia_ticket_id', 'mensaje_conincidencia', 'fecha_inicio_conincidencia', 'fecha_fin_conincidencia',
        'atendido_ticket_id', 'mensaje_atendido', 'fecha_inicio_atendido', 'fecha_fin_atendido',
        'ticket_id', 'created_user_id', 'updated_user_id'
    ];

//    protected $columns = ['id','pseudo','email']; // add all columns from you table

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function ticket()
    {
        return $this->belongsTo(Ticket::class, 'ticket_id');
    }


//    public function scopeExclude($query, $value = array())
//    {
//        return $query->select(array_diff($this->fillable, (array)$value));
//    }
}
