<?php

namespace App\Entities;

//use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model
{
//    use Sluggable;
    use SoftDeletes;
    protected $table = 'tickets';
    protected $dates = ['deleted_at'];
    protected $fillable = [
        'codigo', 'asunto', 'descripcion', 'categoria_ticket_id', 'tipo_ticket_id', 'created_user_id', 'updated_user_id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function ticketEstado()
    {
        return $this->belongsTo(TicketEstado::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function ticketFoto()
    {
        return $this->belongsTo(TicketFoto::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function categoriaTicket()
    {
        return $this->belongsTo(SubLista::class, 'categoria_ticket_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function tipoTicket()
    {
        return $this->belongsTo(SubLista::class, 'tipo_ticket_id');
    }

    /**
     * @param $value
     */
//    public function setAsuntoAttribute($value)
//    {
//        $this->attributes['asunto'] = mb_strtoupper($value, 'utf-8');
//    }

//    /**
//     * @return array
//     */
//    public function sluggable()
//    {
//        return [
//            'slug' => [
//                'source' => ['codigo']
//            ]
//        ];
//    }
}
