<?php

namespace App\Entities;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubLista extends Model
{
    use Sluggable;
    use SoftDeletes;
    protected $table = 'sub_listas';
    protected $dates = ['deleted_at'];
    protected $fillable = [
        'slug', 'nombre', 'descripcion', 'sub_lista_id', 'lista_id', 'created_user_id', 'updated_user_id'
    ];

    /**
     * @param $value
     */
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = mb_strtoupper($value, 'utf-8');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function lista()
    {
        return $this->belongsTo(Lista::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function subLista()
    {
        return $this->belongsTo(SubLista::class, 'sub_lista_id');
    }

    /**
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'nombre'
            ]
        ];
    }
}
