<?php

namespace App\Entities;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sede extends Model
{
    use Sluggable;
    use SoftDeletes;

    protected $table = "sedes";
    protected $dates = ['deleted_at'];

    /**
     * @var array
     */
    protected $fillable = [
        'nombre', 'slug', 'prefijo', 'direccion', 'latitud', 'longitud'
    ];

    /**
     * @param $value
     */
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = mb_strtoupper($value, 'utf-8');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function areas()
    {
        return $this->hasMany(Area::class);
    }

    /**
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'nombre'
            ]
        ];
    }
}
