<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;

class PersonaMessage extends Model
{
    protected $table = "persona_messages";

    protected $fillable = [
        'message', 'persona_id', 'persona_cumpleanio_id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function persona()
    {
        return $this->belongsTo(Persona::class, 'persona_id');
    }

}
