<?php

namespace App\Entities;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Persona extends Model
{
    use Sluggable;
    use SoftDeletes;

    protected $table = "personas";
    protected $dates = ['deleted_at'];

    /**
     * @var array
     */
    protected $fillable = [
        'slug', 'apellidos_nombres', 'dni', 'abreviatura', 'email', 'telefono_personal', 'telefono_empresa', 'anexo',
        'fecha_nacimiento', 'estado_civil', 'genero', 'foto', 'cargo_id'
    ];

    /**
     * @param $value
     */
    public function setApellidosNombresAttribute($value)
    {
        $this->attributes['apellidos_nombres'] = mb_strtoupper($value, 'utf-8');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function cargo()
    {
        return $this->belongsTo(Cargo::class);
    }

    /**
     * @param $cargoId
     * @return string
     */
    public static function sedeAreaCargo($cargoId)
    {
        $cargo = Cargo::find($cargoId);
        $area = Area::find($cargo->area_id);
        $sede = Sede::find($area->sede_id);

        return trim($sede->nombre . ' - ' . $area->nombre . ' - ' . $cargo->nombre);
    }

    public static function getLocalPersona($cargoId)
    {
        $cargo = Cargo::find($cargoId);
        $area = Area::find($cargo->area_id);
        $sede = Sede::find($area->sede_id);

        $return = [
            'cargo' => $cargo,
            'area' => $area,
            'sede' => $sede
        ];

        return $return;
    }

    /**
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => ['apellidos_nombres']
            ]
        ];
    }
}
