<?php

namespace App\Entities;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lista extends Model
{
    use Sluggable;
    use SoftDeletes;
    protected $table = 'listas';
    protected $dates = ['deleted_at'];
    protected $fillable = [
        'slug', 'nombre', 'descripcion', 'created_user_id', 'updated_user_id'
    ];

    /**
     * @param $value
     */
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = mb_strtoupper($value, 'utf-8');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subListas()
    {
        return $this->hasMany(SubLista::class);
    }

    /**
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'nombre'
            ]
        ];
    }
}
