<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;

class Favorito extends Model
{
    protected $table = "favoritos";

    protected $fillable = [
        'user_id', 'persona_id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function persona()
    {
        return $this->belongsTo(Persona::class);
    }
}
