<?php

namespace App\Entities;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cargo extends Model
{
    use Sluggable;
    use SoftDeletes;

    protected $table = "cargos";
    protected $dates = ['deleted_at'];

    /**
     * @var array
     */
    protected $fillable = [
        'nombre', 'slug', 'area_id'
    ];

    /**
     * @param $value
     */
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = mb_strtoupper($value, 'utf-8');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function personas()
    {
        return $this->hasMany(Persona::class);
    }

    /**
     * @param $cargoNombre
     * @param $areaNombre
     * @param $sedeNombre
     * @return mixed
     */
    public static function cargoAreaSede($cargoNombre, $areaNombre, $sedeNombre)
    {
        $area = Area::areaSede($areaNombre, $sedeNombre);
        $cargo = Cargo::where([['nombre', $cargoNombre], ['area_id', $area->id]])->first();

        return $cargo;
    }

    /**
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'nombre'
            ]
        ];
    }
}
