<?php

namespace App\Entities;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Area extends Model
{
    use Sluggable;
    use SoftDeletes;

    protected $table = "areas";
    protected $dates = ['deleted_at'];

    /**
     * @var array
     */
    protected $fillable = [
        'nombre', 'slug', 'sede_id'
    ];

    /**
     * @param $value
     */
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = mb_strtoupper($value, 'utf-8');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function sede()
    {
        return $this->belongsTo(Sede::class);
    }

    public function cargos()
    {
        return $this->hasMany(Cargo::class);
    }

    /**
     * @param $areaNombre
     * @param $sedeNombre
     * @return mixed
     */
    public static function areaSede($areaNombre, $sedeNombre)
    {
        $sede = Sede::where('nombre', $sedeNombre)->first();
        $area = Area::where([['nombre', $areaNombre], ['sede_id', $sede->id]])->first();

        return $area;
    }

    /**
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'nombre'
            ]
        ];
    }
}
