<?php

namespace App\Console\Commands;

use App\Entities\Area;
use App\Entities\Persona;
use App\Entities\Sede;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class PersonalWelcome extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:welcome {dni?}';
//    protected $signature = 'calevano:change-column-table {table?} {--column=} {--length=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envió de e-mail de bienvenida al personal.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $dni = $this->argument('dni');
        if ($dni != null) {
            $persona = Persona::where('dni', $dni)->first();
            if ($persona) {
//                $emails = ['calevano@gmail.com', 'jcalderon@cableperu.net', 'kponte@cableperu.net', 'lromero@cableperu.net', 'bcrisostomo@cableperu.net', 'kabanto@cableperu.net'];
                $emails = ['everyonecvp@cableperu.net', 'everyoneGTC@cableperu.net', 'everyoneutv@cableperu.net'];

                $persona['area'] = Area::find($persona->cargo->area_id);
                $persona['sede'] = Sede::find($persona->area->sede_id);

                $data = [];
                $data['apellidos_nombres'] = $persona->apellidos_nombres;
                $data['cargo'] = $persona->cargo->nombre;
                $data['filial'] = $persona->sede->nombre;
                if ($persona->foto != null) {
                    $data['foto'] = "https://dircorp.cableperu.net.pe/web/perfil/thumbnail/thumb-" . $persona->foto;
                }

                if ($persona->genero == "F") {
                    $genero = "BIENVENIDA";
                    $data['urlImagen'] = "https://dircorp.cableperu.net.pe/assets/email/images/welcome_women.gif";
                } else {
                    $genero = "BIENVENIDO";
                    $data['urlImagen'] = "https://dircorp.cableperu.net.pe/assets/email/images/welcome_men.gif";
                }

                Mail::send('superadmin.herramientas.email.bienvenido', $data, function ($message) use ($persona, $emails, $genero) {
                    $message->from('comunicaciones@cableperu.net', 'Comunicaciones');
                    $message->to($emails);
                    $message->subject('👏 👍 😃 ' . $genero . ' ' . $persona->apellidos_nombres);
                });
                $this->info('Se envió correctamente el saludo de Bienvenida a ' . $persona->apellidos_nombres . '.');
            } else {
                $this->error('No se puede enviar el saludo de Bienvenida, porque no existe personal.');
            }
        } else {
            $this->error('No se envío D.N.I');
        }
    }
}
